/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.mixin.ItemEntityAccessor;

public class CorporeaCrystalCubeBlockEntityRenderer
implements BlockEntityRenderer<CorporeaCrystalCubeBlockEntity> {
    public static BakedModel cubeModel = null;
    private ItemEntity entity = null;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CorporeaCrystalCubeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public void render(@Nullable CorporeaCrystalCubeBlockEntity cube, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ItemStack stack = ItemStack.EMPTY;
        if (cube != null) {
            if (this.entity == null) {
                this.entity = new ItemEntity(cube.getLevel(), (double)cube.getBlockPos().getX(), (double)cube.getBlockPos().getY(), (double)cube.getBlockPos().getZ(), new ItemStack((ItemLike)Blocks.STONE));
            }
            ((ItemEntityAccessor)this.entity).setAge(ClientTickHandler.ticksInGame);
            stack = cube.getRequestTarget();
            this.entity.setItem(stack);
        }
        Minecraft mc = Minecraft.getInstance();
        ms.pushPose();
        ms.translate(0.5f, 1.5f, 0.5f);
        ms.scale(1.0f, -1.0f, -1.0f);
        ms.translate(0.0f, (Mth.sin((float)(((float)this.entity.getAge() + f) / 10.0f + this.entity.bobOffs)) * 0.1f + 0.1f) / -7.0f, 0.0f);
        if (!stack.isEmpty()) {
            ms.pushPose();
            ms.translate(0.0f, 0.96f, 0.0f);
            ms.scale(0.64f, 0.64f, 0.64f);
            ms.mulPose(VecHelper.rotateZ(180.0f));
            Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.entity).render((Entity)this.entity, 0.0f, f, ms, buffers, light);
            ms.popPose();
        }
        if (cubeModel != null) {
            ms.pushPose();
            ms.translate(-0.5f, 0.25f, -0.5f);
            VertexConsumer buffer = buffers.getBuffer(Sheets.translucentCullBlockSheet());
            this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, null, cubeModel, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.popPose();
        }
        if (!stack.isEmpty() && cube != null && !cube.hideCount) {
            int count = cube.getItemCount();
            Object countStr = String.valueOf(count);
            int color = 0xFFFFFF;
            if (count > 9999) {
                countStr = count / 1000 + "K";
                color = 0xFFFF00;
                if (count > 9999999) {
                    countStr = count / 1000000 + "M";
                    color = 65280;
                }
            }
            int colorShade = ((color |= 0xA0000000) & 0xFCFCFC) >> 2 | color & 0xFF000000;
            float s = 0.015625f;
            ms.scale(s, s, s);
            int l = mc.font.width((String)countStr);
            ms.translate(0.0f, 55.0f, 0.0f);
            float tr = -16.5f;
            for (int i = 0; i < 4; ++i) {
                ms.mulPose(VecHelper.rotateY(90.0f));
                ms.translate(0.0f, 0.0f, tr);
                mc.font.drawInBatch((String)countStr, (float)(-l / 2), 0.0f, color, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
                ms.translate(0.0f, 0.0f, 0.1f);
                mc.font.drawInBatch((String)countStr, (float)(-l / 2 + 1), 1.0f, colorShade, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
                ms.translate(0.0f, 0.0f, -tr - 0.1f);
            }
        }
        ms.popPose();
    }
}

