/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class TerraShattererTippingRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<TerraShattererTippingRecipe> SERIALIZER = new NoOpRecipeSerializer<TerraShattererTippingRecipe>(TerraShattererTippingRecipe::new);

    public TerraShattererTippingRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundTerraPick = false;
        boolean foundElementiumPick = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof TerraShattererItem && !TerraShattererItem.isTipped(stack) && !foundTerraPick) {
                foundTerraPick = true;
                continue;
            }
            if (stack.is(BotaniaItems.elementiumPick) && !foundElementiumPick) {
                foundElementiumPick = true;
                continue;
            }
            return false;
        }
        return foundTerraPick && foundElementiumPick;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack terraPick = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof TerraShattererItem)) continue;
            terraPick = stack;
        }
        if (terraPick.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack terraPickCopy = terraPick.copy();
        TerraShattererItem.setTipped(terraPickCopy);
        return terraPickCopy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

