/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;

public class RunicAltarBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape TOP = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)TOP, (VoxelShape)BOTTOM, (BooleanOp)BooleanOp.OR);

    public RunicAltarBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof RunicAltarBlockEntity)) {
            return InteractionResult.PASS;
        }
        RunicAltarBlockEntity altar = (RunicAltarBlockEntity)blockEntity;
        ItemStack stack = player.getItemInHand(hand);
        boolean mainHandEmpty = player.getMainHandItem().isEmpty();
        if (altar.canAddLastRecipe() && mainHandEmpty) {
            return altar.trySetLastRecipe(player);
        }
        if (!altar.isEmpty() && altar.manaToGet == 0 && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(altar, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!stack.isEmpty()) {
            boolean result = altar.addItem(player, stack, hand);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
            if (result) {
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RunicAltarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return RunicAltarBlock.createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::clientTick);
        }
        return RunicAltarBlock.createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::serverTick);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        RunicAltarBlockEntity altar = (RunicAltarBlockEntity)world.getBlockEntity(pos);
        return altar.signal;
    }
}

