/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;

public class LabelliaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int PICKUP_RANGE = 0;
    private static final int RENAME_RANGE = 2;
    private static final int COST = 500;

    public LabelliaBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.LABELLIA, pos, state);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 16772739;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.level.isClientSide && this.redstoneSignal == 0 && this.getMana() >= 500) {
            BlockPos effPos = this.getEffectivePos();
            BlockPos realPos = this.getBlockPos();
            int x = effPos.getX();
            int y = effPos.getY();
            int z = effPos.getZ();
            for (ItemEntity nameTagEnt : this.level.getEntitiesOfClass(ItemEntity.class, new AABB(realPos.offset(0, 0, 0), realPos.offset(1, 1, 1)), EntitySelector.ENTITY_STILL_ALIVE)) {
                ItemStack nameTag;
                if (!DelayHelper.canInteractWith(this, nameTagEnt) || !(nameTag = nameTagEnt.getItem()).is(Items.NAME_TAG) || !nameTag.hasCustomHoverName()) continue;
                AABB renameArea = new AABB((double)(x - 2), (double)y, (double)(z - 2), (double)(x + 2 + 1), (double)(y + 1), (double)(z + 2 + 1));
                Component name = nameTag.getHoverName();
                List nameableEntities = this.level.getEntitiesOfClass(LivingEntity.class, renameArea, EntitySelector.ENTITY_STILL_ALIVE.and(e -> !name.equals(e.getCustomName()) && !(e instanceof Player)));
                List nameableItems = this.level.getEntitiesOfClass(ItemEntity.class, renameArea, i -> DelayHelper.canInteractWith(this, i) && i != nameTagEnt && !name.equals(i.getItem().getHoverName()));
                if (nameableItems.isEmpty() && nameableEntities.isEmpty()) continue;
                for (LivingEntity e2 : nameableEntities) {
                    e2.setCustomName(name);
                    if (!(e2 instanceof Mob)) continue;
                    Mob mob = (Mob)e2;
                    mob.setPersistenceRequired();
                }
                for (ItemEntity i2 : nameableItems) {
                    i2.getItem().setHoverName(name);
                    EntityHelper.syncItem(i2);
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.INSTANT_EFFECT, i2.getX(), i2.getY(), i2.getZ(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                this.addMana(-500);
                EntityHelper.shrinkItem(nameTagEnt);
                this.level.playSound(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, BotaniaSounds.labellia, SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getBlockPos(), 0);
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }
}

