/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfheimPortalBlockEntityRenderer
implements BlockEntityRenderer<AlfheimPortalBlockEntity> {
    private final TextureAtlasSprite portalSprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl")));

    public AlfheimPortalBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull AlfheimPortalBlockEntity portal, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        AlfheimPortalState state = (AlfheimPortalState)((Object)portal.getBlockState().getValue(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF) {
            return;
        }
        float alpha = (float)Math.min(1.0, (Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 7.0 + 0.6) * ((float)Math.min(60, portal.ticksOpen) / 60.0f) * 0.5f;
        ms.pushPose();
        if (state == AlfheimPortalState.ON_X) {
            ms.translate(0.3125, 1.0, 2.0);
            ms.mulPose(VecHelper.rotateY(90.0f));
        } else {
            ms.translate(-1.0, 1.0, 0.3125);
        }
        this.renderIcon(ms, buffers, this.portalSprite, 0, 0, 3, 3, alpha, overlay);
        ms.popPose();
        ms.pushPose();
        if (state == AlfheimPortalState.ON_X) {
            ms.translate(0.6875, 1.0, -1.0);
            ms.mulPose(VecHelper.rotateY(90.0f));
        } else {
            ms.translate(2.0, 1.0, 0.6875);
        }
        ms.mulPose(VecHelper.rotateY(180.0f));
        this.renderIcon(ms, buffers, this.portalSprite, 0, 0, 3, 3, alpha, overlay);
        ms.popPose();
    }

    public void renderIcon(PoseStack ms, MultiBufferSource buffers, TextureAtlasSprite icon, int x, int y, int width, int height, float alpha, int overlay) {
        VertexConsumer buffer = buffers.getBuffer(Sheets.translucentItemSheet());
        Matrix4f model = ms.last().pose();
        Matrix3f normal = ms.last().normal();
        buffer.vertex(model, (float)x, (float)(y + height), 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(icon.getU0(), icon.getV1()).overlayCoords(overlay).uv2(0xF000F0).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(model, (float)(x + width), (float)(y + height), 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(icon.getU1(), icon.getV1()).overlayCoords(overlay).uv2(0xF000F0).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(model, (float)(x + width), (float)y, 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(icon.getU1(), icon.getV0()).overlayCoords(overlay).uv2(0xF000F0).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
        buffer.vertex(model, (float)x, (float)y, 0.0f).color(1.0f, 1.0f, 1.0f, alpha).uv(icon.getU0(), icon.getV0()).overlayCoords(overlay).uv2(0xF000F0).normal(normal, 1.0f, 0.0f, 0.0f).endVertex();
    }
}

