/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class BotanicalBreweryModel
extends Model {
    private static final ResourceLocation TEXTURE = new ResourceLocation("botania:textures/model/brewery.png");
    final ModelPart top;
    final ModelPart pole;
    final ModelPart bottom;
    final ModelPart plate;

    public BotanicalBreweryModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.top = root.getChild("top");
        this.pole = root.getChild("pole");
        this.bottom = root.getChild("bottom");
        this.plate = root.getChild("plate");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("top", CubeListBuilder.create().texOffs(8, 0).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("pole", CubeListBuilder.create().addBox(-1.0f, -6.0f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(8, 5).addBox(-2.0f, 4.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        root.addOrReplaceChild("plate", CubeListBuilder.create().texOffs(8, 5).addBox(5.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        return mesh;
    }

    public void render(@Nullable BreweryBlockEntity brewery, double time, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float offset = (float)Math.sin(time / 40.0) * 0.1f + 0.05f;
        boolean hasTile = brewery != null;
        int plates = hasTile ? brewery.inventorySize() - 1 : 7;
        float deg = (float)time / 16.0f;
        float polerot = -deg * 25.0f;
        ms.translate(0.0f, offset, 0.0f);
        ms.mulPose(VecHelper.rotateY(polerot));
        if (hasTile && !brewery.getItemHandler().getItem(0).isEmpty()) {
            ms.pushPose();
            ms.mulPose(VecHelper.rotateX(180.0f));
            ms.translate(0.0f, -0.45f, 0.0f);
            this.renderItemStack(brewery.getItemHandler().getItem(0), ms, buffers, brewery.getLevel(), light, overlay);
            ms.popPose();
        }
        RenderType layer = this.renderType(TEXTURE);
        this.pole.render(ms, buffers.getBuffer(layer), light, overlay);
        this.top.render(ms, buffers.getBuffer(layer), light, overlay);
        this.bottom.render(ms, buffers.getBuffer(layer), light, overlay);
        ms.mulPose(VecHelper.rotateY(-polerot));
        float degper = (float)Math.PI * 2 / (float)plates;
        for (int i = 0; i < plates; ++i) {
            this.plate.yRot = deg;
            float offset1 = (float)Math.sin(time / 20.0 + (double)((float)i * 40.0f)) * 0.2f - 0.2f;
            if (time == -1.0) {
                offset1 = 0.0f;
            }
            ms.translate(0.0f, offset1, 0.0f);
            if (hasTile && !brewery.getItemHandler().getItem(i + 1).isEmpty()) {
                float rot = this.plate.yRot * 180.0f / (float)Math.PI;
                float transX = 0.3125f;
                float transY = 1.06f;
                float transZ = 0.1245f;
                ms.pushPose();
                ms.mulPose(VecHelper.rotateY(rot));
                ms.translate(transX, transY, transZ);
                ms.mulPose(VecHelper.rotateX(-90.0f));
                ms.translate(0.125f, 0.125f, 0.0f);
                this.renderItemStack(brewery.getItemHandler().getItem(i + 1), ms, buffers, brewery.getLevel(), light, overlay);
                ms.popPose();
            }
            this.plate.render(ms, buffers.getBuffer(layer), light, overlay);
            ms.translate(0.0f, -offset1, 0.0f);
            deg += degper;
        }
        ms.translate(0.0f, -offset, 0.0f);
    }

    private void renderItemStack(ItemStack stack, PoseStack ms, MultiBufferSource buffers, @Nullable Level level, int light, int overlay) {
        if (!stack.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            ms.pushPose();
            float s = 0.25f;
            ms.scale(s, s, s);
            mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffers, level, 0);
            ms.popPose();
        }
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        throw new UnsupportedOperationException("unimplemented, call using other render method");
    }
}

