/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class MoltenCoreRodItem
extends Item {
    private static final int TIME = 10;
    private static final int COST = 300;
    private static final int COST_PER_TICK = 30;
    public static final Map<Player, SmeltData> playerData = new WeakHashMap<Player, SmeltData>();

    public MoltenCoreRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void onUseTick(Level world, LivingEntity living, ItemStack stack, int time) {
        if (!(living instanceof Player)) {
            return;
        }
        Player p = (Player)living;
        SimpleContainer dummyInv = new SimpleContainer(1);
        if (!ManaItemHandler.instance().requestManaExactForTool(stack, p, 30, false)) {
            return;
        }
        BlockHitResult pos = ToolCommons.raytraceFromEntity((Entity)p, 32.0, false);
        if (pos.getType() == HitResult.Type.BLOCK) {
            BlockState state = world.getBlockState(pos.getBlockPos());
            dummyInv.setItem(0, new ItemStack((ItemLike)state.getBlock()));
            world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (Container)dummyInv, p.level()).map(arg_0 -> MoltenCoreRodItem.lambda$onUseTick$0((Container)dummyInv, world, arg_0)).filter(r -> !r.isEmpty() && r.getItem() instanceof BlockItem).ifPresent(result -> {
                SmeltData data;
                boolean decremented = false;
                if (playerData.containsKey(p) && (data = playerData.get(p)).equalPos(pos)) {
                    --data.progress;
                    decremented = true;
                    if (data.progress <= 0) {
                        if (!world.isClientSide) {
                            world.setBlockAndUpdate(pos.getBlockPos(), Block.byItem((Item)result.getItem()).defaultBlockState());
                            world.playSound(null, p.getX(), p.getY(), p.getZ(), BotaniaSounds.smeltRod, SoundSource.PLAYERS, 1.0f, 1.0f);
                            world.playSound(null, p.getX(), p.getY(), p.getZ(), BotaniaSounds.smeltRod2, SoundSource.PLAYERS, 1.0f, 1.0f);
                            ManaItemHandler.instance().requestManaExactForTool(stack, p, 30, true);
                            playerData.remove(p);
                            decremented = false;
                        }
                        WispParticleData data1 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)pos.getBlockPos().getX() + Math.random();
                            double y = (double)pos.getBlockPos().getY() + Math.random();
                            double z = (double)pos.getBlockPos().getZ() + Math.random();
                            world.addParticle((ParticleOptions)data1, x, y, z, 0.0, (double)((float)(-Math.random()) / 10.0f), 0.0);
                        }
                    }
                }
                if (!decremented) {
                    playerData.put(p, new SmeltData(pos, ManaItemHandler.instance().hasProficiency(p, stack) ? 6 : 10));
                } else {
                    for (int i = 0; i < 2; ++i) {
                        double x = (double)pos.getBlockPos().getX() + Math.random();
                        double y = (double)pos.getBlockPos().getY() + Math.random();
                        double z = (double)pos.getBlockPos().getZ() + Math.random();
                        WispParticleData data2 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        world.addParticle((ParticleOptions)data2, x, y, z, 0.0, (double)((float)Math.random() / 10.0f), 0.0);
                    }
                    if (time % 10 == 0) {
                        world.playSound(null, p.getX(), p.getY(), p.getZ(), BotaniaSounds.smeltRodSimmer, SoundSource.PLAYERS, (float)Math.random() / 2.0f + 0.5f, 1.0f);
                    }
                }
            });
        }
    }

    private static /* synthetic */ ItemStack lambda$onUseTick$0(Container dummyInv, Level world, SmeltingRecipe r) {
        return r.assemble(dummyInv, world.registryAccess());
    }

    static class SmeltData {
        public final BlockHitResult pos;
        public int progress;

        public SmeltData(BlockHitResult pos, int progress) {
            this.pos = pos;
            this.progress = progress;
        }

        public boolean equalPos(BlockHitResult pos) {
            return pos.getBlockPos().equals((Object)this.pos.getBlockPos());
        }
    }
}

