/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.xplat.XplatAbstractions;

public class RedirectiveLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        BlockPos sourcePos = burst.getBurstSourceBlockPos();
        ThrowableProjectile burstEntity = burst.entity();
        if (!burstEntity.level().isClientSide && !burst.isFake()) {
            EntityHitResult result;
            BlockHitResult result2;
            if (pos instanceof BlockHitResult && (result2 = (BlockHitResult)pos).getType() != HitResult.Type.MISS && !result2.getBlockPos().equals((Object)sourcePos)) {
                this.handleHitBlock(burst, result2);
            } else if (pos instanceof EntityHitResult && (result = (EntityHitResult)pos).getEntity() != burstEntity.getOwner()) {
                this.handleHitEntity(burst, result);
            }
        }
        return shouldKill;
    }

    @Nullable
    private static Vec3 getSourceVec(ManaBurst burst) {
        ThrowableProjectile entity = burst.entity();
        Entity owner = entity.getOwner();
        BlockPos sourcePos = burst.getBurstSourceBlockPos();
        Level level = entity.level();
        if (!sourcePos.equals((Object)ManaBurst.NO_SOURCE) && burst.isBurstSourceDimension(level) && level.hasChunkAt(sourcePos)) {
            Vec3 sourceVec = Vec3.atCenterOf((Vec3i)sourcePos);
            VoxelShape collideShape = level.getBlockState(sourcePos).getCollisionShape((BlockGetter)level, sourcePos);
            AABB axis = collideShape.isEmpty() ? new AABB(sourcePos, sourcePos.offset(1, 1, 1)) : collideShape.bounds().move(sourcePos);
            if (!axis.contains(sourceVec)) {
                sourceVec = new Vec3(axis.minX + (axis.maxX - axis.minX) / 2.0, axis.minY + (axis.maxY - axis.minY) / 2.0, axis.minZ + (axis.maxZ - axis.minZ) / 2.0);
            }
            return sourceVec;
        }
        if (owner != null) {
            return owner.getEyePosition();
        }
        return null;
    }

    private void handleHitEntity(ManaBurst burst, EntityHitResult result) {
        Vec3 sourceVec = RedirectiveLens.getSourceVec(burst);
        if (sourceVec != null) {
            result.getEntity().lookAt(EntityAnchorArgument.Anchor.EYES, sourceVec);
        }
    }

    private void handleHitBlock(ManaBurst burst, BlockHitResult result) {
        Vec3 sourceVec = RedirectiveLens.getSourceVec(burst);
        if (sourceVec == null) {
            return;
        }
        ThrowableProjectile entity = burst.entity();
        BlockPos hitPos = result.getBlockPos();
        ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(entity.level(), hitPos, result.getDirection());
        if (receiver instanceof ManaSpreader) {
            ManaSpreader spreader = (ManaSpreader)receiver;
            Vec3 tileVec = Vec3.atCenterOf((Vec3i)hitPos);
            Vec3 diffVec = sourceVec.subtract(tileVec);
            Vec3 diffVec2D = new Vec3(diffVec.x, diffVec.z, 0.0);
            Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
            double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
            if (sourceVec.x < tileVec.x) {
                angle = -angle;
            }
            spreader.setRotationX((float)angle + 90.0f);
            rotVec = new Vec3(diffVec.x, 0.0, diffVec.z);
            angle = MathHelper.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
            if (sourceVec.y < tileVec.y) {
                angle = -angle;
            }
            spreader.setRotationY((float)angle);
            spreader.commitRedirection();
            if (spreader instanceof ThrottledPacket) {
                ThrottledPacket pkt = (ThrottledPacket)((Object)spreader);
                pkt.markDispatchable();
            }
        }
    }
}

