/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.lib.BotaniaTags;

public class FloralFertilizerItem
extends Item {
    private static final int RANGE = 3;

    public FloralFertilizerItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (!world.isClientSide) {
            BlockState belowState;
            Optional flowersTag = BuiltInRegistries.BLOCK.getTag(BotaniaTags.Blocks.MYSTICAL_FLOWERS);
            Optional mushroomsTag = BuiltInRegistries.BLOCK.getTag(BotaniaTags.Blocks.SHIMMERING_MUSHROOMS);
            boolean flowersAvailable = flowersTag.map(holders -> holders.size() > 0).orElse(false);
            boolean mushroomsAvailable = mushroomsTag.map(holders -> holders.size() > 0).orElse(false);
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (BlockPos candidatePos : BlockPos.betweenClosed((int)(pos.getX() - 3), (int)(pos.getY() - 2), (int)(pos.getZ() - 3), (int)(pos.getX() + 3), (int)(pos.getY() + 2), (int)(pos.getZ() + 3))) {
                if (!world.isInWorldBounds(candidatePos) || !world.isEmptyBlock(candidatePos)) continue;
                belowState = world.getBlockState(candidatePos.below());
                if ((!flowersAvailable || !FloralFertilizerItem.canPlaceFlower(belowState, world)) && (!mushroomsAvailable || !FloralFertilizerItem.canPlaceMushroom(belowState))) continue;
                validCoords.add(candidatePos.immutable());
            }
            int petalCount = world.random.nextIntBetweenInclusive(5, 7);
            while (petalCount > 0 && !validCoords.isEmpty()) {
                Optional toPlace;
                boolean tryPlaceMushroom;
                --petalCount;
                BlockPos coords = (BlockPos)validCoords.get(world.random.nextInt(validCoords.size()));
                validCoords.remove(coords);
                belowState = world.getBlockState(coords.below());
                boolean tryPlaceFlower = flowersAvailable && FloralFertilizerItem.canPlaceFlower(belowState, world);
                boolean bl = tryPlaceMushroom = mushroomsAvailable && FloralFertilizerItem.canPlaceMushroom(belowState);
                if (tryPlaceMushroom && (!tryPlaceFlower || world.random.nextInt(3) == 0)) {
                    toPlace = ((HolderSet.Named)mushroomsTag.get()).getRandomElement(world.random);
                } else {
                    if (!tryPlaceFlower) continue;
                    toPlace = ((HolderSet.Named)flowersTag.get()).getRandomElement(world.random);
                    --petalCount;
                }
                if (!toPlace.isPresent() || ((Block)((Holder)toPlace.get()).value()).defaultBlockState().isAir()) continue;
                world.setBlockAndUpdate(coords, ((Block)((Holder)toPlace.get()).value()).defaultBlockState());
            }
            ctx.getItemInHand().shrink(1);
        } else {
            for (int i = 0; i < 15; ++i) {
                double x = (double)(pos.getX() - 3 + world.random.nextInt(7)) + Math.random();
                double y = pos.getY() + 1;
                double z = (double)(pos.getZ() - 3 + world.random.nextInt(7)) + Math.random();
                float red = (float)Math.random();
                float green = (float)Math.random();
                float blue = (float)Math.random();
                WispParticleData data = WispParticleData.wisp(0.15f + (float)Math.random() * 0.25f, red, green, blue, 1.0f);
                world.addParticle((ParticleOptions)data, x, y, z, 0.0, (double)((float)Math.random() * 0.1f - 0.05f), 0.0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    private static boolean canPlaceMushroom(BlockState belowState) {
        return belowState.is(BlockTags.MUSHROOM_GROW_BLOCK);
    }

    private static boolean canPlaceFlower(BlockState belowState, Level world) {
        return belowState.is(BlockTags.DIRT) && !world.dimensionType().ultraWarm();
    }
}

