/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.xplat.BotaniaConfig;

public class EnderHandItem
extends Item {
    private static final int COST_PROVIDE = 5;
    private static final int COST_SELF = 250;
    private static final int COST_OTHER = 5000;

    public EnderHandItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ManaItemHandler.instance().requestManaExact(stack, player, 250, false)) {
            if (!player.level().isClientSide) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> ChestMenu.threeRows((int)windowId, (Inventory)playerInv, (Container)p.getEnderChestInventory()), stack.getHoverName()));
                ManaItemHandler.instance().requestManaExact(stack, player, 250, true);
            }
            player.playSound(SoundEvents.ENDER_CHEST_OPEN, 1.0f, 1.0f);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.isAlive() && BotaniaConfig.common().enderPickpocketEnabled() && entity instanceof Player) {
            Player other = (Player)entity;
            if (ManaItemHandler.instance().requestManaExact(stack, player, 5000, false)) {
                if (!player.level().isClientSide) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> ChestMenu.threeRows((int)windowId, (Inventory)playerInv, (Container)other.getEnderChestInventory()), stack.getHoverName()));
                    ManaItemHandler.instance().requestManaExact(stack, player, 5000, true);
                }
                player.playSound(SoundEvents.ENDER_CHEST_OPEN, 1.0f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
            }
        }
        return InteractionResult.PASS;
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        private final ItemStack stack;

        public BlockProviderImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            boolean mana;
            if (!requestor.isEmpty() && requestor.is(this.stack.getItem())) {
                return false;
            }
            ItemStack istack = ShiftingCrustRodItem.removeFromInventory(player, (Container)player.getEnderChestInventory(), this.stack, block.asItem(), false);
            if (!istack.isEmpty() && (mana = ManaItemHandler.instance().requestManaExact(this.stack, player, 5, false))) {
                if (doit) {
                    ManaItemHandler.instance().requestManaExact(this.stack, player, 5, true);
                    ShiftingCrustRodItem.removeFromInventory(player, (Container)player.getEnderChestInventory(), this.stack, block.asItem(), true);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (!requestor.isEmpty() && requestor.is(this.stack.getItem())) {
                return 0;
            }
            return ShiftingCrustRodItem.getInventoryItemCount(player, (Container)player.getEnderChestInventory(), this.stack, block.asItem());
        }
    }
}

