/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.CorporeaSparkEntity;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

public class CorporeaSparkItem
extends Item {
    public CorporeaSparkItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        return CorporeaSparkItem.attachSpark(ctx.getLevel(), ctx.getClickedPos(), ctx.getItemInHand()) ? InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    private static boolean canPlace(Level world, CorporeaSparkEntity spark) {
        return world.getBlockState(spark.getAttachPos()).is(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE) || !(spark.getSparkNode() instanceof DummyCorporeaNode);
    }

    public static boolean attachSpark(Level world, BlockPos pos, ItemStack stack) {
        CorporeaSparkEntity spark = (CorporeaSparkEntity)BotaniaEntities.CORPOREA_SPARK.create(world);
        if (stack.is(BotaniaItems.corporeaSparkMaster)) {
            spark.setMaster(true);
        }
        if (stack.is(BotaniaItems.corporeaSparkCreative)) {
            spark.setCreative(true);
        }
        spark.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.25, (double)pos.getZ() + 0.5);
        if (CorporeaSparkItem.canPlace(world, spark) && !CorporeaHelper.instance().doesBlockHaveSpark(world, pos)) {
            if (!world.isClientSide) {
                world.addFreshEntity((Entity)spark);
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.is(BotaniaItems.corporeaSparkCreative)) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.creativeSpark").withStyle(ChatFormatting.GRAY));
        }
    }
}

