/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;

public class CorporeaStringMatcher
implements CorporeaRequestMatcher {
    private static final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    public static final String[] WILDCARD_STRINGS = new String[]{"...", "~", "+", "?"};
    private static final String TAG_REQUEST_CONTENTS = "requestContents";
    private final String[] expression;

    public CorporeaStringMatcher(String expression) {
        boolean contains = false;
        for (String wc : WILDCARD_STRINGS) {
            if (expression.endsWith(wc)) {
                contains = true;
                expression = expression.substring(0, expression.length() - wc.length());
            } else if (expression.startsWith(wc)) {
                contains = true;
                expression = expression.substring(wc.length());
            }
            if (contains) break;
        }
        this.expression = ((String)(contains ? "*" + expression + "*" : expression)).split("\\*+", -1);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        String name = CorporeaStringMatcher.stripControlCodes(stack.getHoverName().getString().toLowerCase(Locale.ROOT).trim());
        return this.matchGlob(name) || this.matchGlob(name + "s") || this.matchGlob(name + "es") || name.endsWith("y") && this.matchGlob(name.substring(0, name.length() - 1) + "ies");
    }

    public static CorporeaStringMatcher createFromNBT(CompoundTag tag) {
        String expression = tag.getString(TAG_REQUEST_CONTENTS);
        return new CorporeaStringMatcher(expression);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.putString(TAG_REQUEST_CONTENTS, this.toString());
    }

    @Override
    public Component getRequestName() {
        Object value = WordUtils.capitalizeFully((String)this.toString());
        if (((String)value).charAt(0) == '*' && ((String)value).length() >= 2) {
            value = "*" + Character.toUpperCase(((String)value).charAt(1)) + ((String)value).substring(2);
        }
        return Component.literal((String)("\"" + (String)value + "\""));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("*");
        for (String s : this.expression) {
            sj.add(s);
        }
        return sj.toString();
    }

    private boolean matchGlob(String str) {
        if (this.expression.length == 1) {
            return this.expression[0].equals(str);
        }
        if (!str.startsWith(this.expression[0])) {
            return false;
        }
        int offset = this.expression[0].length();
        for (int i = 1; i < this.expression.length - 1; ++i) {
            String section = this.expression[i];
            int found = str.indexOf(section, offset);
            if (found == -1) {
                return false;
            }
            offset = found + section.length();
        }
        return str.substring(offset).endsWith(this.expression[this.expression.length - 1]);
    }

    private static String stripControlCodes(String str) {
        return patternControlCode.matcher(str).replaceAll("");
    }
}

