/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;

public class CosmeticAttachRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new NoOpRecipeSerializer<CosmeticAttachRecipe>(CosmeticAttachRecipe::new);

    public CosmeticAttachRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundCosmetic = false;
        boolean foundAttachable = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CosmeticBauble && !foundCosmetic) {
                foundCosmetic = true;
                continue;
            }
            if (foundAttachable) continue;
            Item item = stack.getItem();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.getItem() instanceof CosmeticBauble) && attachable.getCosmeticItem(stack).isEmpty()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundCosmetic && foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        Item stack;
        ItemStack cosmeticItem = ItemStack.EMPTY;
        ItemStack attachableItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CosmeticBauble && cosmeticItem.isEmpty()) {
                cosmeticItem = stack;
                continue;
            }
            attachableItem = stack;
        }
        stack = attachableItem.getItem();
        if (!(stack instanceof CosmeticAttachable)) {
            return ItemStack.EMPTY;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)stack;
        if (!attachable.getCosmeticItem(attachableItem).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = attachableItem.copy();
        attachable.setCosmeticItem(copy, cosmeticItem);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

