/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class FallenKanadeBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 2;
    private static final int COST = 120;

    public FallenKanadeBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.FALLEN_KANADE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide) {
            boolean did = false;
            List entities = this.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getEffectivePos().offset(-2, -2, -2), this.getEffectivePos().offset(3, 3, 3)), FallenKanadeBlockEntity::canHeal);
            for (LivingEntity toHeal : entities) {
                if (toHeal.getEffect(MobEffects.REGENERATION) != null || this.getMana() < 120) continue;
                toHeal.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 59, 2, true, true));
                this.addMana(-120);
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    private static boolean canHeal(LivingEntity e) {
        AbstractHorse horse;
        TamableAnimal animal;
        Player player;
        if (!e.isAlive()) {
            return false;
        }
        return e instanceof Player && !(player = (Player)e).isSpectator() || e instanceof TamableAnimal && (animal = (TamableAnimal)e).isTame() || e instanceof AbstractHorse && (horse = (AbstractHorse)e).isTamed();
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public int getColor() {
        return 0xFFFF00;
    }

    @Override
    public int getMaxMana() {
        return 900;
    }
}

