/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.serverbound;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public class DodgePacket
implements BotaniaPacket {
    public static final DodgePacket INSTANCE = new DodgePacket();
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("do");

    public static DodgePacket decode(FriendlyByteBuf buf) {
        return INSTANCE;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.dash, SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemStack ringStack = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)player);
            if (ringStack.isEmpty()) {
                player.connection.disconnect((Component)Component.translatable((String)"botaniamisc.invalidDodge"));
                return;
            }
            player.causeFoodExhaustion(0.3f);
            ItemNBTHelper.setInt(ringStack, "dodgeCooldown", 20);
        });
    }
}

