/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.box.BaubleBoxContainer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemBackedInventory;
import vazkii.botania.xplat.XplatAbstractions;

public class BaubleBoxItem
extends Item {
    public static final int SIZE = 24;
    public static final String TAG_OPEN = "open";

    public BaubleBoxItem(Item.Properties props) {
        super(props);
    }

    public static SimpleContainer getInventory(ItemStack stack) {
        return new ItemBackedInventory(stack, 24){

            public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
                return EquipmentHandler.instance.isAccessory(stack);
            }
        };
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        if (!world.isClientSide) {
            final ItemStack stack = player.getItemInHand(hand);
            ItemNBTHelper.setBoolean(stack, TAG_OPEN, true);
            XplatAbstractions.INSTANCE.openMenu((ServerPlayer)player, new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    return new BaubleBoxContainer(syncId, inv, stack);
                }
            }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)world.isClientSide());
    }

    public void onDestroyed(@NotNull ItemEntity entity) {
        SimpleContainer container = BaubleBoxItem.getInventory(entity.getItem());
        Stream<ItemStack> stream = IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((SimpleContainer)container).getItem(arg_0)).filter(s -> !s.isEmpty());
        ItemUtils.onContainerDestroyed((ItemEntity)entity, stream);
        container.clearContent();
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack box, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        return InventoryHelper.overrideStackedOnOther(BaubleBoxItem::getInventory, player.containerMenu instanceof BaubleBoxContainer, box, slot, clickAction, player);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack box, @NotNull ItemStack toInsert, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess cursorAccess) {
        return InventoryHelper.overrideOtherStackedOnMe(BaubleBoxItem::getInventory, player.containerMenu instanceof BaubleBoxContainer, box, toInsert, clickAction, cursorAccess);
    }
}

