/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class PetalsRecipe
implements PetalApothecaryRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient reagent;
    private final NonNullList<Ingredient> inputs;

    public PetalsRecipe(ResourceLocation id, ItemStack output, Ingredient reagent, Ingredient ... inputs) {
        Preconditions.checkArgument((inputs.length <= 16 ? 1 : 0) != 0, (Object)"Cannot have more than 16 ingredients");
        this.id = id;
        this.output = output;
        this.reagent = reagent;
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs);
    }

    @Override
    public Ingredient getReagent() {
        return this.reagent;
    }

    public boolean matches(Container inv, @NotNull Level world) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.getContainerSize() && !(input = inv.getItem(i)).isEmpty(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @NotNull
    public final ItemStack getResultItem(@NotNull RegistryAccess registries) {
        return this.output;
    }

    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess registries) {
        return this.getResultItem(registries).copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.defaultAltar);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.PETAL_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PetalsRecipe> {
        @NotNull
        public PetalsRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            Ingredient reagent = Ingredient.fromJson((JsonElement)json.get("reagent"));
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.fromJson((JsonElement)e));
            }
            return new PetalsRecipe(id, output, reagent, inputs.toArray(new Ingredient[0]));
        }

        public PetalsRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            Ingredient reagent = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            ItemStack output = buf.readItem();
            return new PetalsRecipe(id, output, reagent, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull PetalsRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient input : recipe.getIngredients()) {
                input.toNetwork(buf);
            }
            recipe.reagent.toNetwork(buf);
            buf.writeItem(recipe.output);
        }
    }
}

