/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.FloatingFlowerBlockEntityRenderer;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity>
implements BlockEntityRenderer<T> {
    public static final int INNER_ALPHA = 32;
    public static final int OUTER_ALPHA = 64;
    public static final float FRAME_WIDTH = 0.0625f;
    public static final float Y_OFFSET_INNER = 0.0625f;
    public static final float Y_OFFSET_OUTER = 0.078125f;
    public static final int TOTAL_ANGLES = 360;
    public static final double DEGREES_TO_RADIAN = Math.PI / 180;

    public SpecialFlowerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SpecialFlowerBlockEntity tile, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        Entity entity;
        if (tile.isFloating()) {
            FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
        }
        if (!((entity = Minecraft.getInstance().cameraEntity) instanceof LivingEntity)) {
            return;
        }
        LivingEntity view = (LivingEntity)entity;
        if (!ManaseerMonocleItem.hasMonocle(view)) {
            return;
        }
        BlockPos pos = null;
        HitResult ray = Minecraft.getInstance().hitResult;
        if (ray != null && ray.getType() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)ray).getBlockPos();
        }
        if ((hasBindingAttempt = SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.getBlockPos())) || tile.getBlockPos().equals((Object)pos)) {
            SpecialFlowerBlockEntity flower = tile;
            ms.pushPose();
            if (hasBindingAttempt) {
                ms.translate(0.0, 0.005, 0.0);
            }
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.translate(0.0, 0.002, 0.0);
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.popPose();
        }
    }

    public static void renderRadius(BlockEntity tile, PoseStack ms, MultiBufferSource buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.pushPose();
            ms.translate(0.0, RenderHelper.getOffY(), 0.0);
            if (descriptor instanceof RadiusDescriptor.Circle) {
                RadiusDescriptor.Circle circle = (RadiusDescriptor.Circle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderCircle(ms, buffers, tile.getBlockPos(), circle.subtileCoords(), circle.radius());
            } else if (descriptor instanceof RadiusDescriptor.Rectangle) {
                RadiusDescriptor.Rectangle rectangle = (RadiusDescriptor.Rectangle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderRectangle(ms, buffers, tile.getBlockPos(), rectangle.aabb());
            }
            RenderHelper.incrementOffY();
            ms.popPose();
        }
    }

    public static boolean hasBindingAttempt(LivingEntity view, BlockPos tilePos) {
        ItemStack stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
        if (!stackHeld.isEmpty() && WandOfTheForestItem.getBindMode(stackHeld)) {
            return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(arg_0 -> ((BlockPos)tilePos).equals(arg_0)).isPresent();
        }
        return false;
    }

    public static void renderCircle(PoseStack ms, MultiBufferSource buffers, BlockPos tilePos, BlockPos center, double radius) {
        ms.pushPose();
        ms.translate((double)(center.getX() - tilePos.getX()) + 0.5, (double)(center.getY() - tilePos.getY()), (double)(center.getZ() - tilePos.getZ()) + 0.5);
        int color = Mth.hsvToRgb((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.CIRCLE);
        Matrix4f mat = ms.last().pose();
        double innerRadius = radius - 0.0625;
        Runnable centerFuncInner = () -> buffer.vertex(mat, 0.0f, 0.0625f, 0.0f).color(r, g, b, 32).endVertex();
        Runnable centerFuncOuter = () -> buffer.vertex(mat, 0.0f, 0.078125f, 0.0f).color(r, g, b, 64).endVertex();
        Runnable[] vertexFuncsInner = new Runnable[361];
        Runnable[] vertexFuncsOuter = new Runnable[361];
        for (int i = 0; i < 360; ++i) {
            double rad = (double)(360 - i) * (Math.PI / 180);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            float xpInner = (float)(cos * innerRadius);
            float zpInner = (float)(sin * innerRadius);
            vertexFuncsInner[i] = () -> buffer.vertex(mat, xpInner, 0.0625f, zpInner).color(r, g, b, 32).endVertex();
            float xpOuter = (float)(Math.cos(rad) * radius);
            float zpOuter = (float)(Math.sin(rad) * radius);
            vertexFuncsOuter[i] = () -> buffer.vertex(mat, xpOuter, 0.078125f, zpOuter).color(r, g, b, 64).endVertex();
        }
        vertexFuncsInner[360] = vertexFuncsInner[0];
        vertexFuncsOuter[360] = vertexFuncsOuter[0];
        RenderHelper.triangleFan(centerFuncInner, vertexFuncsInner);
        RenderHelper.triangleFan(centerFuncOuter, vertexFuncsOuter);
        ms.popPose();
    }

    public static void renderRectangle(PoseStack ms, MultiBufferSource buffers, BlockPos tilePos, AABB aabb) {
        ms.pushPose();
        ms.translate(aabb.minX - (double)tilePos.getX(), aabb.minY - (double)tilePos.getY(), aabb.minZ - (double)tilePos.getZ());
        int color = Mth.hsvToRgb((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float xSize = (float)aabb.getXsize();
        float zSize = (float)aabb.getZsize();
        float xSizeInner = xSize - 0.0625f;
        float zSizeInner = zSize - 0.0625f;
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.last().pose();
        RenderHelper.flatRectangle(buffer, mat, 0.0625f, xSizeInner, 0.0625f, 0.0625f, zSizeInner, r, g, b, 32);
        RenderHelper.flatRectangle(buffer, mat, 0.0f, xSize, 0.078125f, 0.0f, zSize, r, g, b, 64);
        ms.popPose();
    }
}

