/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class ManaPumpBlockEntityRenderer
implements BlockEntityRenderer<ManaPumpBlockEntity> {
    public static BakedModel headModel = null;
    private final BlockRenderDispatcher blockRenderDispatcher;

    public ManaPumpBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public void render(ManaPumpBlockEntity pump, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.pushPose();
        ms.translate(0.5, 0.0, 0.5);
        float angle = 0.0f;
        switch ((Direction)pump.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            default: {
                break;
            }
            case SOUTH: {
                angle = 180.0f;
                break;
            }
            case EAST: {
                angle = -90.0f;
                break;
            }
            case WEST: {
                angle = 90.0f;
            }
        }
        ms.mulPose(VecHelper.rotateY(angle));
        ms.translate(-0.5, 0.0, -0.5);
        double diff = Math.max(0.0f, Math.min(8.0f, pump.innerRingPos + pump.moving * partialTicks));
        ms.translate(0.0, 0.0, diff / 14.0);
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, null, headModel, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.popPose();
    }
}

