/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaSpark;

public abstract class AbstractCorporeaNode
implements CorporeaNode {
    private final Level world;
    private final BlockPos pos;
    private final CorporeaSpark spark;

    public AbstractCorporeaNode(Level world, BlockPos pos, CorporeaSpark spark) {
        this.world = world;
        this.pos = pos;
        this.spark = spark;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public CorporeaSpark getSpark() {
        return this.spark;
    }

    protected static Collection<ItemStack> breakDownBigStack(ItemStack stack) {
        if (stack.getCount() <= stack.getMaxStackSize()) {
            return Collections.singleton(stack);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int additionalStacks = stack.getCount() / stack.getMaxStackSize();
        ItemStack fullStack = stack.copyWithCount(stack.getMaxStackSize());
        for (int i = 0; i < additionalStacks; ++i) {
            stacks.add(fullStack.copy());
        }
        int lastStackSize = stack.getCount() % stack.getMaxStackSize();
        ItemStack lastStack = stack.copyWithCount(lastStackSize);
        stacks.add(lastStack);
        return stacks;
    }
}

