/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.mixin.BundleItemAccessor;

public class FilterHelper {
    public static final String ITEMS_TAG = "Items";

    public static List<ItemStack> getFilterItems(ItemFrame filterFrame) {
        ItemStack filterStack = filterFrame.getItem();
        if (filterStack.isEmpty()) {
            return List.of();
        }
        return filterFrame instanceof GlowItemFrame ? FilterHelper.getFilterStacks(filterStack) : List.of(filterStack);
    }

    public static List<ItemStack> getFilterStacks(ItemStack filterStack) {
        if (filterStack.is(Items.BUNDLE)) {
            List<ItemStack> bundledItems = BundleItemAccessor.call_getContents(filterStack).toList();
            if (!bundledItems.isEmpty()) {
                return bundledItems;
            }
        } else {
            List<ItemStack> items;
            CompoundTag tag;
            CompoundTag compoundTag = tag = filterStack.getItem() instanceof BlockItem ? BlockItem.getBlockEntityData((ItemStack)filterStack) : filterStack.getTag();
            if (tag != null && tag.contains(ITEMS_TAG, 9) && (items = FilterHelper.getItemStacks(tag)) != null) {
                return items;
            }
        }
        return List.of(filterStack);
    }

    @Nullable
    private static List<ItemStack> getItemStacks(CompoundTag tag) {
        try {
            ListTag contents = tag.getList(ITEMS_TAG, 10);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                CompoundTag entry = contents.getCompound(i);
                ItemStack stack = ItemStack.of((CompoundTag)entry);
                if (stack.isEmpty()) continue;
                items.add(stack);
            }
            if (!items.isEmpty()) {
                return items;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public record WeightedItemStack(ItemStack stack, Weight weight) implements WeightedEntry
    {
        public static WeightedItemStack of(ItemStack stack, int weight) {
            return new WeightedItemStack(stack, Weight.of((int)weight));
        }

        @NotNull
        public Weight getWeight() {
            return this.weight;
        }
    }
}

