/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.brew;

import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.alchemy.PotionUtils;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BotaniaBrews {
    public static final Brew fallbackBrew = new Brew(0, 0, new MobEffectInstance[0]).setNotBloodPendantInfusable().setNotIncenseInfusable();
    public static final Brew speed = new Brew(5879807, 4000, new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1800, 1));
    public static final Brew strength = new Brew(0xEE3F3F, 4000, new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1800, 1));
    public static final Brew haste = new Brew(16032818, 4000, new MobEffectInstance(MobEffects.DIG_SPEED, 1800, 1));
    public static final Brew healing = new Brew(16735948, 6000, new MobEffectInstance(MobEffects.HEAL, 1, 1));
    public static final Brew jumpBoost = new Brew(3339373, 4000, new MobEffectInstance(MobEffects.JUMP, 1800, 1));
    public static final Brew regen = new Brew(16606344, 7000, new MobEffectInstance(MobEffects.REGENERATION, 500, 1));
    public static final Brew regenWeak = new Brew(16606344, 9000, new MobEffectInstance(MobEffects.REGENERATION, 2400, 0));
    public static final Brew resistance = new Brew(11816471, 4000, new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800, 1));
    public static final Brew fireResistance = new Brew(16279808, 4000, new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 9600, 0));
    public static final Brew waterBreathing = new Brew(8693711, 4000, new MobEffectInstance(MobEffects.WATER_BREATHING, 9600, 0));
    public static final Brew invisibility = new Brew(0xAEAEAE, 8000, new MobEffectInstance(MobEffects.INVISIBILITY, 9600, 0)).setNotBloodPendantInfusable();
    public static final Brew nightVision = new Brew(8145899, 4000, new MobEffectInstance(MobEffects.NIGHT_VISION, 9600, 0));
    public static final Brew absorption = new Brew(15919907, 7000, new MobEffectInstance(MobEffects.ABSORPTION, 1800, 3)).setNotBloodPendantInfusable().setNotIncenseInfusable();
    public static final Brew allure = BotaniaBrews.make(2000, new MobEffectInstance(BotaniaMobEffects.allure, 4800, 0));
    public static final Brew soulCross = BotaniaBrews.make(10000, new MobEffectInstance(BotaniaMobEffects.soulCross, 1800, 0));
    public static final Brew featherfeet = BotaniaBrews.make(7000, new MobEffectInstance(BotaniaMobEffects.featherfeet, 1800, 0));
    public static final Brew emptiness = BotaniaBrews.make(30000, new MobEffectInstance(BotaniaMobEffects.emptiness, 7200, 0));
    public static final Brew bloodthirst = BotaniaBrews.make(20000, new MobEffectInstance(BotaniaMobEffects.bloodthrst, 7200, 0));
    public static final Brew overload = new Brew(0x232323, 12000, new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1800, 3), new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1800, 2), new MobEffectInstance(MobEffects.WEAKNESS, 3600, 1), new MobEffectInstance(MobEffects.HUNGER, 200, 2));
    public static final Brew clear = BotaniaBrews.make(4000, new MobEffectInstance(BotaniaMobEffects.clear, 0, 0));

    public static void submitRegistrations(BiConsumer<Brew, ResourceLocation> r) {
        r.accept(fallbackBrew, ResourceLocationHelper.prefix("fallback"));
        r.accept(speed, ResourceLocationHelper.prefix("speed"));
        r.accept(strength, ResourceLocationHelper.prefix("strength"));
        r.accept(haste, ResourceLocationHelper.prefix("haste"));
        r.accept(healing, ResourceLocationHelper.prefix("healing"));
        r.accept(jumpBoost, ResourceLocationHelper.prefix("jump_boost"));
        r.accept(regen, ResourceLocationHelper.prefix("regen"));
        r.accept(regenWeak, ResourceLocationHelper.prefix("regen_weak"));
        r.accept(resistance, ResourceLocationHelper.prefix("resistance"));
        r.accept(fireResistance, ResourceLocationHelper.prefix("fire_resistance"));
        r.accept(waterBreathing, ResourceLocationHelper.prefix("water_breathing"));
        r.accept(invisibility, ResourceLocationHelper.prefix("invisibility"));
        r.accept(nightVision, ResourceLocationHelper.prefix("night_vision"));
        r.accept(absorption, ResourceLocationHelper.prefix("absorption"));
        r.accept(overload, ResourceLocationHelper.prefix("overload"));
        r.accept(soulCross, ResourceLocationHelper.prefix("soul_cross"));
        r.accept(featherfeet, ResourceLocationHelper.prefix("feather_feet"));
        r.accept(emptiness, ResourceLocationHelper.prefix("emptiness"));
        r.accept(bloodthirst, ResourceLocationHelper.prefix("bloodthirst"));
        r.accept(allure, ResourceLocationHelper.prefix("allure"));
        r.accept(clear, ResourceLocationHelper.prefix("clear"));
    }

    private static Brew make(int cost, MobEffectInstance ... effects) {
        return new Brew(PotionUtils.getColor(Arrays.asList(effects)), cost, effects);
    }
}

