/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;

abstract class RotatingItemListComponentBase
implements ICustomComponent {
    protected transient List<Ingredient> ingredients;
    protected transient int x;
    protected transient int y;

    RotatingItemListComponentBase() {
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX != -1 ? componentX : 17;
        this.y = componentY;
        this.ingredients = this.makeIngredients();
    }

    protected abstract List<Ingredient> makeIngredients();

    public void render(GuiGraphics gui, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        int degreePerInput = (int)(360.0f / (float)this.ingredients.size());
        int ticksElapsed = context.getTicksInBook();
        float currentDegree = BotaniaConfig.client().lexiconRotatingItems() ? (Screen.hasShiftDown() ? (float)ticksElapsed : (float)ticksElapsed + pticks) : 0.0f;
        for (Ingredient input : this.ingredients) {
            this.renderIngredientAtAngle(gui, context, currentDegree, input, mouseX, mouseY);
            currentDegree += (float)degreePerInput;
        }
    }

    private void renderIngredientAtAngle(GuiGraphics gui, IComponentRenderContext context, float angle, Ingredient ingredient, int mouseX, int mouseY) {
        PoseStack ms = gui.pose();
        if (ingredient.isEmpty()) {
            return;
        }
        int radius = 32;
        double xPos = (double)this.x + Math.cos((double)(angle -= 90.0f) * Math.PI / 180.0) * (double)radius + 32.0;
        double yPos = (double)this.y + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + 32.0;
        ms.pushPose();
        ms.translate(xPos - (double)((int)xPos), yPos - (double)((int)yPos), 0.0);
        context.renderIngredient(gui, (int)xPos, (int)yPos, mouseX, mouseY, ingredient);
        ms.popPose();
    }
}

