/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ColorHelper {
    public static final Function<DyeColor, Block> STAINED_GLASS_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_stained_glass"));
    public static final Function<DyeColor, Block> STAINED_GLASS_PANE_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_stained_glass_pane"));
    public static final Function<DyeColor, Block> TERRACOTTA_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_terracotta"));
    public static final Function<DyeColor, Block> GLAZED_TERRACOTTA_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_glazed_terracotta"));
    public static final Function<DyeColor, Block> WOOL_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_wool"));
    public static final Function<DyeColor, Block> CARPET_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_carpet"));
    public static final Function<DyeColor, Block> CONCRETE_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_concrete"));
    public static final Function<DyeColor, Block> CONCRETE_POWDER_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_concrete_powder"));
    public static final Function<DyeColor, Block> CANDLE_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_candle"));
    public static final Function<DyeColor, Block> CANDLE_CAKE_MAP = color -> (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(color.getSerializedName() + "_candle_cake"));

    @Nullable
    public static DyeColor getWoolColor(Block b) {
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)b);
        if ("minecraft".equals(name.getNamespace()) && name.getPath().endsWith("_wool")) {
            String color = name.getPath().substring(0, name.getPath().length() - "_wool".length());
            return DyeColor.byName((String)color, null);
        }
        return null;
    }

    public static boolean isWool(Block b) {
        return ColorHelper.getWoolColor(b) != null;
    }

    public static int getColorValue(DyeColor color) {
        float[] colors = color.getTextureDiffuseColors();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorLegibleOnGrayBackground(DyeColor color) {
        return switch (color) {
            case DyeColor.BLACK -> 0x808080;
            case DyeColor.GRAY -> 0xA0A0A0;
            case DyeColor.BLUE -> 0x6666FF;
            case DyeColor.BROWN -> 9135427;
            default -> color.getTextColor();
        };
    }

    public static Stream<DyeColor> supportedColors() {
        return Stream.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
    }

    private ColorHelper() {
    }
}

