/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.ExoflameHeatable;
import vazkii.botania.mixin.AbstractFurnaceBlockEntityAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ExoflameFurnaceHandler {
    public static boolean canSmeltRecipe(AbstractFurnaceBlockEntity furnace, Recipe<?> recipe) {
        NonNullList<ItemStack> items = ((AbstractFurnaceBlockEntityAccessor)furnace).getItems();
        return XplatAbstractions.INSTANCE.canFurnaceBurn(furnace, recipe, items, furnace.getMaxStackSize());
    }

    public static boolean canSmelt(AbstractFurnaceBlockEntity furnace) {
        if (furnace.getItem(0).isEmpty()) {
            return false;
        }
        try {
            RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> qc = ((AbstractFurnaceBlockEntityAccessor)furnace).getQuickCheck();
            Optional currentRecipe = qc.getRecipeFor((Container)furnace, furnace.getLevel());
            return currentRecipe.isPresent() && ExoflameFurnaceHandler.canSmeltRecipe(furnace, (Recipe)currentRecipe.get());
        }
        catch (Throwable t) {
            BotaniaAPI.LOGGER.error("Failed to determine if furnace TE can smelt", t);
            return false;
        }
    }

    public static class FurnaceExoflameHeatable
    implements ExoflameHeatable {
        private final AbstractFurnaceBlockEntity furnace;

        public FurnaceExoflameHeatable(AbstractFurnaceBlockEntity furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canSmelt() {
            return ExoflameFurnaceHandler.canSmelt(this.furnace);
        }

        @Override
        public int getBurnTime() {
            return ((AbstractFurnaceBlockEntityAccessor)this.furnace).getLitTime();
        }

        @Override
        public void boostBurnTime() {
            if (this.getBurnTime() == 0) {
                Level world = this.furnace.getLevel();
                BlockPos pos = this.furnace.getBlockPos();
                world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            }
            int burnTime = ((AbstractFurnaceBlockEntityAccessor)this.furnace).getLitTime();
            ((AbstractFurnaceBlockEntityAccessor)this.furnace).setLitTime(burnTime + 200);
        }

        @Override
        public void boostCookTime() {
            int cookTime = ((AbstractFurnaceBlockEntityAccessor)this.furnace).getCookingProgress();
            int cookTimeTotal = ((AbstractFurnaceBlockEntityAccessor)this.furnace).getCookingTotalTime();
            ((AbstractFurnaceBlockEntityAccessor)this.furnace).setCookingProgress(Math.min(cookTimeTotal - 1, cookTime + 1));
        }
    }
}

