/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.entity.BabylonWeaponEntity;
import vazkii.botania.common.entity.CorporeaSparkEntity;
import vazkii.botania.common.entity.EnderAirBottleEntity;
import vazkii.botania.common.entity.EnderAirEntity;
import vazkii.botania.common.entity.FallingStarEntity;
import vazkii.botania.common.entity.FlameRingEntity;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.entity.MagicLandmineEntity;
import vazkii.botania.common.entity.MagicMissileEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.entity.ManaPoolMinecartEntity;
import vazkii.botania.common.entity.ManaSparkEntity;
import vazkii.botania.common.entity.ManaStormEntity;
import vazkii.botania.common.entity.PinkWitherEntity;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.entity.ThornChakramEntity;
import vazkii.botania.common.entity.ThrownItemEntity;
import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.lib.LibEntityNames;

public final class BotaniaEntities {
    public static final EntityType<ManaBurstEntity> MANA_BURST = EntityType.Builder.of(ManaBurstEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).updateInterval(10).clientTrackingRange(6).build(LibEntityNames.MANA_BURST.toString());
    public static final EntityType<PixieEntity> PIXIE = EntityType.Builder.of(PixieEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).updateInterval(3).clientTrackingRange(6).build(LibEntityNames.PIXIE.toString());
    public static final EntityType<FlameRingEntity> FLAME_RING = EntityType.Builder.of(FlameRingEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(3).updateInterval(40).build(LibEntityNames.FLAME_RING.toString());
    public static final EntityType<VineBallEntity> VINE_BALL = EntityType.Builder.of(VineBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(LibEntityNames.VINE_BALL.toString());
    public static final EntityType<GaiaGuardianEntity> DOPPLEGANGER = EntityType.Builder.of(GaiaGuardianEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.8f).fireImmune().clientTrackingRange(10).updateInterval(10).build(LibEntityNames.DOPPLEGANGER.toString());
    public static final EntityType<MagicLandmineEntity> MAGIC_LANDMINE = EntityType.Builder.of(MagicLandmineEntity::new, (MobCategory)MobCategory.MISC).sized(5.0f, 0.1f).clientTrackingRange(8).updateInterval(40).build(LibEntityNames.MAGIC_LANDMINE.toString());
    public static final EntityType<ManaSparkEntity> SPARK = EntityType.Builder.of(ManaSparkEntity::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.5f).fireImmune().clientTrackingRange(4).updateInterval(10).build(LibEntityNames.SPARK.toString());
    public static final EntityType<ThrownItemEntity> THROWN_ITEM = EntityType.Builder.of(ThrownItemEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(20).build(LibEntityNames.THROWN_ITEM.toString());
    public static final EntityType<MagicMissileEntity> MAGIC_MISSILE = EntityType.Builder.of(MagicMissileEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(4).updateInterval(2).build(LibEntityNames.MAGIC_MISSILE.toString());
    public static final EntityType<ThornChakramEntity> THORN_CHAKRAM = EntityType.Builder.of(ThornChakramEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(5).updateInterval(10).build(LibEntityNames.THORN_CHAKRAM.toString());
    public static final EntityType<CorporeaSparkEntity> CORPOREA_SPARK = EntityType.Builder.of(CorporeaSparkEntity::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.5f).fireImmune().clientTrackingRange(4).updateInterval(40).build(LibEntityNames.CORPOREA_SPARK.toString());
    public static final EntityType<EnderAirBottleEntity> ENDER_AIR_BOTTLE = EntityType.Builder.of(EnderAirBottleEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(LibEntityNames.ENDER_AIR_BOTTLE.toString());
    public static final EntityType<ManaPoolMinecartEntity> POOL_MINECART = EntityType.Builder.of(ManaPoolMinecartEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.7f).clientTrackingRange(5).updateInterval(3).build(LibEntityNames.POOL_MINECART.toString());
    public static final EntityType<PinkWitherEntity> PINK_WITHER = EntityType.Builder.of(PinkWitherEntity::new, (MobCategory)MobCategory.MISC).sized(0.9f, 3.5f).clientTrackingRange(6).updateInterval(3).build(LibEntityNames.PINK_WITHER.toString());
    public static final EntityType<LuminizerBlockEntity.PlayerMoverEntity> PLAYER_MOVER = EntityType.Builder.of(LuminizerBlockEntity.PlayerMoverEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(10).updateInterval(3).build(LibEntityNames.PLAYER_MOVER.toString());
    public static final EntityType<ManaStormEntity> MANA_STORM = EntityType.Builder.of(ManaStormEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(4).updateInterval(10).build(LibEntityNames.MANA_STORM.toString());
    public static final EntityType<BabylonWeaponEntity> BABYLON_WEAPON = EntityType.Builder.of(BabylonWeaponEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(6).updateInterval(10).build(LibEntityNames.BABYLON_WEAPON.toString());
    public static final EntityType<FallingStarEntity> FALLING_STAR = EntityType.Builder.of(FallingStarEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).clientTrackingRange(4).updateInterval(10).build(LibEntityNames.FALLING_STAR.toString());
    public static final EntityType<EnderAirEntity> ENDER_AIR = EntityType.Builder.of(EnderAirEntity::new, (MobCategory)MobCategory.MISC).fireImmune().sized(1.0f, 1.0f).clientTrackingRange(4).updateInterval(Integer.MAX_VALUE).build(LibEntityNames.ENDER_AIR.toString());

    public static void registerEntities(BiConsumer<EntityType<?>, ResourceLocation> r) {
        r.accept(MANA_BURST, LibEntityNames.MANA_BURST);
        r.accept(PIXIE, LibEntityNames.PIXIE);
        r.accept(FLAME_RING, LibEntityNames.FLAME_RING);
        r.accept(VINE_BALL, LibEntityNames.VINE_BALL);
        r.accept(DOPPLEGANGER, LibEntityNames.DOPPLEGANGER);
        r.accept(MAGIC_LANDMINE, LibEntityNames.MAGIC_LANDMINE);
        r.accept(SPARK, LibEntityNames.SPARK);
        r.accept(THROWN_ITEM, LibEntityNames.THROWN_ITEM);
        r.accept(MAGIC_MISSILE, LibEntityNames.MAGIC_MISSILE);
        r.accept(THORN_CHAKRAM, LibEntityNames.THORN_CHAKRAM);
        r.accept(CORPOREA_SPARK, LibEntityNames.CORPOREA_SPARK);
        r.accept(ENDER_AIR_BOTTLE, LibEntityNames.ENDER_AIR_BOTTLE);
        r.accept(POOL_MINECART, LibEntityNames.POOL_MINECART);
        r.accept(PINK_WITHER, LibEntityNames.PINK_WITHER);
        r.accept(PLAYER_MOVER, LibEntityNames.PLAYER_MOVER);
        r.accept(MANA_STORM, LibEntityNames.MANA_STORM);
        r.accept(BABYLON_WEAPON, LibEntityNames.BABYLON_WEAPON);
        r.accept(FALLING_STAR, LibEntityNames.FALLING_STAR);
        r.accept(ENDER_AIR, LibEntityNames.ENDER_AIR);
    }

    public static void registerAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> consumer) {
        consumer.accept(DOPPLEGANGER, Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 320.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0));
        consumer.accept(PIXIE, Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 2.0));
        consumer.accept(PINK_WITHER, WitherBoss.createAttributes());
    }

    public static void registerWandHudCaps(ECapConsumer<WandHUD> consumer) {
        consumer.accept(e -> new ManaSparkEntity.WandHud((ManaSparkEntity)e), SPARK);
        consumer.accept(e -> new CorporeaSparkEntity.WandHud((CorporeaSparkEntity)e), CORPOREA_SPARK);
    }

    @FunctionalInterface
    public static interface ECapConsumer<T> {
        public void accept(Function<Entity, T> var1, EntityType<?> ... var2);
    }
}

