/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RunicAltarRecipe
implements vazkii.botania.api.recipe.RunicAltarRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;
    private final int mana;

    public RunicAltarRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        Preconditions.checkArgument((inputs.length <= 16 ? 1 : 0) != 0, (Object)"Cannot have more than 16 ingredients");
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])inputs);
        this.mana = mana;
    }

    public boolean matches(Container inv, @NotNull Level world) {
        return RecipeUtils.matches(this.inputs, inv, null);
    }

    @NotNull
    public final ItemStack getResultItem(@NotNull RegistryAccess registries) {
        return this.output;
    }

    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess registries) {
        return this.getResultItem(registries).copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.runeAltar);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.RUNE_SERIALIZER;
    }

    @Override
    public int getManaUsage() {
        return this.mana;
    }

    public static class Serializer
    implements RecipeSerializer<RunicAltarRecipe> {
        @NotNull
        public RunicAltarRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            int mana = GsonHelper.getAsInt((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.fromJson((JsonElement)e));
            }
            return new RunicAltarRecipe(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public RunicAltarRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.readItem();
            int mana = buf.readVarInt();
            return new RunicAltarRecipe(id, output, mana, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull RunicAltarRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient input : recipe.getIngredients()) {
                input.toNetwork(buf);
            }
            buf.writeItem(recipe.output);
            buf.writeVarInt(recipe.getManaUsage());
        }
    }
}

