/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class ManaInfusionRecipe
implements vazkii.botania.api.recipe.ManaInfusionRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient input;
    private final int mana;
    @Nullable
    private final StateIngredient catalyst;
    private final String group;

    public ManaInfusionRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group, @Nullable StateIngredient catalyst) {
        Preconditions.checkArgument((mana > 0 ? 1 : 0) != 0, (Object)"Mana cost must be positive");
        Preconditions.checkArgument((mana <= 1000001 ? 1 : 0) != 0, (Object)"Mana cost must be at most a pool");
        this.id = id;
        this.output = output;
        this.input = input;
        this.mana = mana;
        this.group = group == null ? "" : group;
        this.catalyst = catalyst;
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<ManaInfusionRecipe> getSerializer() {
        return BotaniaRecipeTypes.MANA_INFUSION_SERIALIZER;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    public StateIngredient getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getManaToConsume() {
        return this.mana;
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess registries) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.manaPool);
    }

    public static class Serializer
    implements RecipeSerializer<ManaInfusionRecipe> {
        @NotNull
        public ManaInfusionRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            JsonElement input = Objects.requireNonNull(json.get("input"));
            Ingredient ing = Ingredient.fromJson((JsonElement)input);
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            int mana = GsonHelper.getAsInt((JsonObject)json, (String)"mana");
            String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
            StateIngredient catalyst = null;
            if (json.has("catalyst")) {
                JsonElement element = json.get("catalyst");
                if (!element.isJsonObject() || !element.getAsJsonObject().has("type")) {
                    throw new JsonParseException("Legacy mana infusion catalyst syntax used");
                }
                catalyst = StateIngredientHelper.deserialize(element.getAsJsonObject());
            }
            return new ManaInfusionRecipe(id, output, ing, mana, group, catalyst);
        }

        @Nullable
        public ManaInfusionRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient input = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            ItemStack output = buf.readItem();
            int mana = buf.readVarInt();
            StateIngredient catalyst = null;
            if (buf.readBoolean()) {
                catalyst = StateIngredientHelper.read(buf);
            }
            String group = buf.readUtf();
            return new ManaInfusionRecipe(id, output, input, mana, group, catalyst);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull ManaInfusionRecipe recipe) {
            ((Ingredient)recipe.getIngredients().get(0)).toNetwork(buf);
            buf.writeItem(recipe.output);
            buf.writeVarInt(recipe.getManaToConsume());
            boolean hasCatalyst = recipe.getRecipeCatalyst() != null;
            buf.writeBoolean(hasCatalyst);
            if (hasCatalyst) {
                recipe.getRecipeCatalyst().write(buf);
            }
            buf.writeUtf(recipe.getGroup());
        }
    }
}

