/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class SpectranthemumBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int BASE_COST = 2;
    private static final int RANGE = 2;
    private BlockPos bindPos = Bound.UNBOUND_POS;

    public SpectranthemumBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SPECTRANTHEMUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide && this.redstoneSignal == 0 && this.getLevel().hasChunkAt(this.bindPos)) {
            BlockPos pos = this.getEffectivePos();
            boolean did = false;
            List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, new AABB(pos.offset(-2, -2, -2), pos.offset(3, 3, 3)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!DelayHelper.canInteractWith(this, item) || XplatAbstractions.INSTANCE.findManaItem(stack = item.getItem()) != null) continue;
                double cost = (double)(2 * stack.getCount()) * Math.sqrt(this.bindPos.distToCenterSqr((Position)item.position()));
                if (!((double)this.getMana() >= cost)) continue;
                SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item, 10);
                BlockPos sourcePos = item.blockPosition();
                item.setPos((double)this.bindPos.getX() + 0.5, (double)this.bindPos.getY() + 1.5, (double)this.bindPos.getZ() + 0.5);
                EntityHelper.addTeleportTicketIfFarAway((Entity)item, sourcePos);
                item.setDeltaMovement(Vec3.ZERO);
                SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item, 10);
                this.addMana(-((int)cost));
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    static void spawnExplosionParticles(Entity item, int p) {
        XplatAbstractions.INSTANCE.sendToTracking(item, new BotaniaEffectPacket(EffectType.ITEM_SMOKE, item.getX(), item.getY(), item.getZ(), item.getId(), p));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.putInt(TAG_BIND_X, this.bindPos.getX());
        cmp.putInt(TAG_BIND_Y, this.bindPos.getY());
        cmp.putInt(TAG_BIND_Z, this.bindPos.getZ());
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.bindPos = new BlockPos(cmp.getInt(TAG_BIND_X), cmp.getInt(TAG_BIND_Y), cmp.getInt(TAG_BIND_Z));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 10009855;
    }

    @Override
    public int getMaxMana() {
        return 5000;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!(bound || pos.equals((Object)this.bindPos) || pos.equals((Object)this.getEffectivePos()))) {
            this.bindPos = pos;
            this.sync();
            return true;
        }
        return bound;
    }

    @Override
    public BlockPos getBinding() {
        return Proxy.INSTANCE.getClientPlayer().isShiftKeyDown() && this.bindPos.getY() != Integer.MIN_VALUE ? this.bindPos : super.getBinding();
    }
}

