/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class CorporeaRequestTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("corporea_index_request");
    public static final CorporeaRequestTrigger INSTANCE = new CorporeaRequestTrigger();

    private CorporeaRequestTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    protected Instance createInstance(JsonObject json, ContextAwarePredicate playerPredicate, DeserializationContext conditions) {
        return new Instance(playerPredicate, MinMaxBounds.Ints.fromJson((JsonElement)json.get("extracted")), LocationPredicate.fromJson((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, int count) {
        this.trigger(player, instance -> instance.test(world, pos, count));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints count;
        private final LocationPredicate indexPos;

        public Instance(ContextAwarePredicate playerPredicate, MinMaxBounds.Ints count, LocationPredicate indexPos) {
            super(ID, playerPredicate);
            this.count = count;
            this.indexPos = indexPos;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ServerLevel world, BlockPos pos, int count) {
            return this.count.matches(count) && this.indexPos.matches(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.count != MinMaxBounds.Ints.ANY) {
                json.add("extracted", this.count.serializeToJson());
            }
            if (this.indexPos != LocationPredicate.ANY) {
                json.add("location", this.indexPos.serializeToJson());
            }
            return json;
        }

        public MinMaxBounds.Ints getCount() {
            return this.count;
        }

        public LocationPredicate getIndexPos() {
            return this.indexPos;
        }
    }
}

