/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.helper.VecHelper;

public class ManaSpreaderBlockEntityRenderer
implements BlockEntityRenderer<ManaSpreaderBlockEntity> {
    public ManaSpreaderBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull ManaSpreaderBlockEntity spreader, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.pushPose();
        ms.translate(0.5, 0.5, 0.5);
        Quaternionf transform = VecHelper.rotateY(spreader.rotationX + 90.0f);
        transform.mul((Quaternionfc)VecHelper.rotateX(spreader.rotationY));
        ms.mulPose(transform);
        ms.translate(-0.5f, -0.5f, -0.5f);
        double time = (float)ClientTickHandler.ticksInGame + partialTicks;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (spreader.getVariant() == ManaSpreaderBlock.Variant.GAIA) {
            int color = Mth.hsvToRgb((float)((float)((time * 2.0 + (double)new Random(spreader.getBlockPos().hashCode()).nextInt(10000)) % 360.0) / 360.0f), (float)0.4f, (float)0.9f);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        VertexConsumer buffer = buffers.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)spreader.getBlockState(), (boolean)false));
        BakedModel spreaderModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(spreader.getBlockState());
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffer, spreader.getBlockState(), spreaderModel, r, g, b, light, overlay);
        ms.pushPose();
        ms.translate(0.5, 0.5, 0.5);
        ms.mulPose(VecHelper.rotateY((float)time % 360.0f));
        ms.translate(-0.5, -0.5, -0.5);
        ms.translate(0.0f, (float)Math.sin(time / 20.0) * 0.05f, 0.0f);
        BakedModel core = this.getCoreModel(spreader);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffer, spreader.getBlockState(), core, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.popPose();
        ItemStack stack = spreader.getItemHandler().getItem(0);
        if (!stack.isEmpty()) {
            ms.pushPose();
            ms.translate(0.5f, 0.5f, 0.094f);
            ms.mulPose(VecHelper.rotateZ(180.0f));
            ms.mulPose(VecHelper.rotateX(180.0f));
            ms.scale(0.997f, 0.997f, 1.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, light, overlay, ms, buffers, spreader.getLevel(), 0);
            ms.popPose();
        }
        if (spreader.paddingColor != null) {
            ms.pushPose();
            ms.translate(0.5f, 0.5f, 0.5f);
            ms.mulPose(VecHelper.rotateX(-90.0f));
            ms.mulPose(VecHelper.rotateY(180.0f));
            ms.translate(-0.5f, -0.5f, -0.5f);
            BakedModel paddingModel = this.getPaddingModel(spreader.paddingColor);
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffer, spreader.getBlockState(), paddingModel, r, g, b, light, overlay);
            ms.popPose();
        }
        ms.popPose();
        if (((Boolean)spreader.getBlockState().getValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
            BakedModel scaffolding = this.getScaffoldingModel(spreader);
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(ms.last(), buffer, spreader.getBlockState(), scaffolding, r, g, b, light, overlay);
        }
    }

    private BakedModel getCoreModel(ManaSpreaderBlockEntity tile) {
        return switch (tile.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case ManaSpreaderBlock.Variant.GAIA -> MiscellaneousModels.INSTANCE.gaiaSpreaderCore;
            case ManaSpreaderBlock.Variant.REDSTONE -> MiscellaneousModels.INSTANCE.redstoneSpreaderCore;
            case ManaSpreaderBlock.Variant.ELVEN -> MiscellaneousModels.INSTANCE.elvenSpreaderCore;
            case ManaSpreaderBlock.Variant.MANA -> MiscellaneousModels.INSTANCE.manaSpreaderCore;
        };
    }

    private BakedModel getPaddingModel(DyeColor color) {
        return MiscellaneousModels.INSTANCE.spreaderPaddings.get(color);
    }

    private BakedModel getScaffoldingModel(ManaSpreaderBlockEntity tile) {
        return switch (tile.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case ManaSpreaderBlock.Variant.REDSTONE, ManaSpreaderBlock.Variant.MANA -> MiscellaneousModels.INSTANCE.manaSpreaderScaffolding;
            case ManaSpreaderBlock.Variant.ELVEN -> MiscellaneousModels.INSTANCE.elvenSpreaderScaffolding;
            case ManaSpreaderBlock.Variant.GAIA -> MiscellaneousModels.INSTANCE.gaiaSpreaderScaffolding;
        };
    }
}

