/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.XplatAbstractions;

public record ItemAgePacket(int entityId, int timeCounter) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("ia");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.entityId());
        buf.writeVarInt(this.timeCounter());
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static ItemAgePacket decode(FriendlyByteBuf buf) {
        return new ItemAgePacket(buf.readVarInt(), buf.readVarInt());
    }

    public static class Handler {
        public static void handle(ItemAgePacket packet) {
            int entityId = packet.entityId();
            int counter = packet.timeCounter();
            Minecraft.getInstance().execute(() -> {
                Entity e = Minecraft.getInstance().level.getEntity(entityId);
                if (e instanceof ItemEntity) {
                    ItemEntity item = (ItemEntity)e;
                    XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter = counter;
                }
            });
        }
    }
}

