/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.lens.Lens;

public class WarpLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        Level world = entity.level();
        if (world.isClientSide || pos.getType() != HitResult.Type.BLOCK) {
            return shouldKill;
        }
        BlockPos hit = ((BlockHitResult)pos).getBlockPos();
        if (world.getBlockState(hit).is(BotaniaBlocks.pistonRelay)) {
            ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get(world);
            BlockPos dest = data.mapping.get(hit);
            if (dest != null) {
                BlockPos sourcePos = entity.blockPosition();
                entity.setPos(dest.getCenter());
                EntityHelper.addTeleportTicketIfFarAway((Entity)entity, sourcePos);
                burst.setCollidedAt(dest);
                burst.setWarped(true);
                return false;
            }
        }
        return shouldKill;
    }
}

