/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterLensRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<ManaBlasterLensRecipe> SERIALIZER = new NoOpRecipeSerializer<ManaBlasterLensRecipe>(ManaBlasterLensRecipe::new);

    public ManaBlasterLensRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        int foundLens = 0;
        int foundGun = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ManaBlasterItem && ManaBlasterItem.getLens(stack).isEmpty()) {
                ++foundGun;
                continue;
            }
            if (ManaBlasterItem.isValidLens(stack)) {
                ++foundLens;
                continue;
            }
            return false;
        }
        return foundLens == 1 && foundGun == 1;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack lens = ItemStack.EMPTY;
        ItemStack gun = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ManaBlasterItem) {
                gun = stack;
                continue;
            }
            if (!(stack.getItem() instanceof BasicLensItem)) continue;
            lens = stack.copyWithCount(1);
        }
        if (lens.isEmpty() || gun.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack gunCopy = gun.copy();
        ManaBlasterItem.setLens(gunCopy, lens);
        return gunCopy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

