/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaSpreaderBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = ManaSpreaderBlock.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_PADDING = ManaSpreaderBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_SCAFFOLDING = ManaSpreaderBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final Variant variant;

    public ManaSpreaderBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
        this.variant = v;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BotaniaStateProperties.HAS_SCAFFOLDING});
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape voxelShape;
        if (((Boolean)blockState.getValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
            return SHAPE_SCAFFOLDING;
        }
        BlockEntity be = blockGetter.getBlockEntity(blockPos);
        if (be instanceof ManaSpreaderBlockEntity) {
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)be;
            if (spreader.paddingColor != null) {
                voxelShape = SHAPE_PADDING;
                return voxelShape;
            }
        }
        voxelShape = SHAPE;
        return voxelShape;
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return SHAPE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.orderedByNearest((Entity)placer)[0].getOpposite();
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)world.getBlockEntity(pos);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean shouldInsert;
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof ManaSpreaderBlockEntity)) {
            return InteractionResult.PASS;
        }
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() instanceof WandOfTheForestItem) {
            return InteractionResult.PASS;
        }
        boolean mainHandEmpty = player.getMainHandItem().isEmpty();
        ItemStack lens = spreader.getItemHandler().getItem(0);
        boolean playerHasLens = heldItem.getItem() instanceof BasicLensItem;
        boolean lensIsSame = playerHasLens && ItemStack.isSameItemSameTags((ItemStack)heldItem, (ItemStack)lens);
        ItemStack wool = spreader.paddingColor != null ? new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor)) : ItemStack.EMPTY;
        boolean playerHasWool = ColorHelper.isWool(Block.byItem((Item)heldItem.getItem()));
        boolean woolIsSame = playerHasWool && ItemStack.isSameItemSameTags((ItemStack)heldItem, (ItemStack)wool);
        boolean playerHasScaffolding = !heldItem.isEmpty() && heldItem.is(Items.SCAFFOLDING);
        boolean bl = shouldInsert = playerHasLens && !lensIsSame || playerHasWool && !woolIsSame || playerHasScaffolding && (Boolean)state.getValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING) == false;
        if (shouldInsert) {
            if (playerHasLens) {
                ItemStack toInsert = heldItem.split(1);
                if (!lens.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(lens);
                }
                spreader.getItemHandler().setItem(0, toInsert);
                world.playSound(player, pos, BotaniaSounds.spreaderAddLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (playerHasWool) {
                Block woolBlock = Block.byItem((Item)heldItem.getItem());
                heldItem.shrink(1);
                if (spreader.paddingColor != null) {
                    ItemStack spreaderWool = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                    player.getInventory().placeItemBackInInventory(spreaderWool);
                }
                spreader.paddingColor = ColorHelper.getWoolColor(woolBlock);
                spreader.setChanged();
                world.playSound(player, pos, BotaniaSounds.spreaderCover, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(true)));
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                world.playSound(player, pos, BotaniaSounds.spreaderScaffold, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (((Boolean)state.getValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue() && player.isSecondaryUseActive()) {
            if (!player.getAbilities().instabuild) {
                ItemStack scaffolding = new ItemStack((ItemLike)Items.SCAFFOLDING);
                player.getInventory().placeItemBackInInventory(scaffolding);
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            world.playSound(player, pos, BotaniaSounds.spreaderUnScaffold, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!lens.isEmpty() && (mainHandEmpty || lensIsSame)) {
            player.getInventory().placeItemBackInInventory(lens);
            spreader.getItemHandler().setItem(0, ItemStack.EMPTY);
            world.playSound(player, pos, BotaniaSounds.spreaderRemoveLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (spreader.paddingColor != null && (mainHandEmpty || woolIsSame)) {
            player.getInventory().placeItemBackInInventory(wool);
            spreader.paddingColor = null;
            spreader.setChanged();
            world.playSound(player, pos, BotaniaSounds.spreaderUncover, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (!(tile instanceof ManaSpreaderBlockEntity)) {
                return;
            }
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
            if (spreader.paddingColor != null) {
                ItemStack padding = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)padding);
            }
            if (((Boolean)state.getValue((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
                ItemStack scaffolding = new ItemStack((ItemLike)Items.SCAFFOLDING);
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)scaffolding);
            }
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)spreader.getItemHandler());
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaSpreaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaSpreaderBlock.createTickerHelper(type, BotaniaBlockEntities.SPREADER, ManaSpreaderBlockEntity::commonTick);
    }

    public static enum Variant {
        MANA(160, 1000, 0x20FF20, 65280, 60, 4.0f, 1.0f),
        REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4.0f, 1.0f),
        ELVEN(240, 1000, 16729540, 16711854, 80, 4.0f, 1.25f),
        GAIA(640, 6400, 0x20FF20, 65280, 120, 20.0f, 2.0f);

        public final int burstMana;
        public final int manaCapacity;
        public final int color;
        public final int hudColor;
        public final int preLossTicks;
        public final float lossPerTick;
        public final float motionModifier;

        private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
            this.burstMana = bm;
            this.manaCapacity = mc;
            this.color = c;
            this.hudColor = hc;
            this.preLossTicks = plt;
            this.lossPerTick = lpt;
            this.motionModifier = mm;
        }
    }
}

