/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class OpenCrateBlockEntity
extends ExposedSimpleInventoryBlockEntity {
    public OpenCrateBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaBlockEntities.OPEN_CRATE, pos, state);
    }

    protected OpenCrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, OpenCrateBlockEntity self) {
        ItemStack stack;
        boolean redstone = level.hasNeighborSignal(worldPosition);
        if (self.canEject() && !(stack = self.getItemHandler().getItem(0)).isEmpty()) {
            self.eject(stack, redstone);
        }
    }

    public boolean canEject() {
        float width = EntityType.ITEM.getWidth();
        float height = EntityType.ITEM.getHeight();
        double ejectX = (double)this.worldPosition.getX() + 0.5;
        double ejectY = (float)this.worldPosition.getY() - height;
        double ejectZ = (double)this.worldPosition.getZ() + 0.5;
        AABB itemBB = new AABB(ejectX - (double)(width / 2.0f), ejectY, ejectZ - (double)(width / 2.0f), ejectX + (double)(width / 2.0f), ejectY + (double)height, ejectZ + (double)(width / 2.0f));
        return this.level.noCollision(itemBB);
    }

    public void eject(ItemStack stack, boolean redstone) {
        double ejectY = (float)this.worldPosition.getY() - EntityType.ITEM.getHeight();
        ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, ejectY, (double)this.worldPosition.getZ() + 0.5, stack);
        item.setDeltaMovement(Vec3.ZERO);
        if (redstone) {
            XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter = -200;
        }
        this.getItemHandler().setItem(0, ItemStack.EMPTY);
        this.level.addFreshEntity((Entity)item);
    }

    @Override
    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return false;
    }
}

