/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block.FloatingFlowerImpl;
import vazkii.botania.api.block.FloatingFlowerProvider;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;

public class FloatingFlowerBlockEntity
extends BotaniaBlockEntity
implements FloatingFlowerProvider {
    private static final String TAG_FLOATING_DATA = "floating";
    private final FloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public ItemStack getDisplayStack() {
            Block b = FloatingFlowerBlockEntity.this.getBlockState().getBlock();
            if (b instanceof FloatingFlowerBlock) {
                FloatingFlowerBlock floatingFlower = (FloatingFlowerBlock)b;
                return new ItemStack((ItemLike)BotaniaBlocks.getShinyFlower(floatingFlower.color));
            }
            return ItemStack.EMPTY;
        }
    };

    public FloatingFlowerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.MINI_ISLAND, pos, state);
    }

    @Override
    public FloatingFlower getFloatingData() {
        return this.floatingData;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.put(TAG_FLOATING_DATA, this.floatingData.writeNBT());
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        FloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        this.floatingData.readNBT(cmp.getCompound(TAG_FLOATING_DATA));
        if (oldType != this.floatingData.getIslandType() && this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public Object getRenderData() {
        return this.floatingData.getIslandType();
    }
}

