/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.SparkEntity;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class PaintslingerLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        block6: {
            int storedColor;
            ThrowableProjectile entity;
            block7: {
                Entity collidedWith;
                block8: {
                    entity = burst.entity();
                    storedColor = LensItem.getStoredColor(stack);
                    if (entity.level().isClientSide || burst.isFake() || storedColor <= -1 || storedColor >= 17) break block6;
                    if (pos.getType() != HitResult.Type.ENTITY) break block7;
                    collidedWith = ((EntityHitResult)pos).getEntity();
                    if (!(collidedWith instanceof Sheep)) break block8;
                    Sheep sheep = (Sheep)collidedWith;
                    int r = 20;
                    DyeColor sheepColor = sheep.getColor();
                    List sheepList = entity.level().getEntitiesOfClass(Sheep.class, new AABB(sheep.getX() - (double)r, sheep.getY() - (double)r, sheep.getZ() - (double)r, sheep.getX() + (double)r, sheep.getY() + (double)r, sheep.getZ() + (double)r));
                    for (Sheep other : sheepList) {
                        if (other.getColor() != sheepColor) continue;
                        other.setColor(DyeColor.byId((int)(storedColor == 16 ? other.level().random.nextInt(16) : storedColor)));
                    }
                    shouldKill = true;
                    break block6;
                }
                if (!(collidedWith instanceof SparkEntity)) break block6;
                SparkEntity spark = (SparkEntity)collidedWith;
                spark.setNetwork(DyeColor.byId((int)(storedColor == 16 ? collidedWith.level().random.nextInt(16) : storedColor)));
                break block6;
            }
            if (pos.getType() == HitResult.Type.BLOCK) {
                BlockPos hitPos = ((BlockHitResult)pos).getBlockPos();
                Block hitBlock = entity.level().getBlockState(hitPos).getBlock();
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)hitBlock);
                if (BotaniaAPI.instance().getPaintableBlocks().containsKey(blockId)) {
                    ArrayList<BlockPos> coordsToPaint = new ArrayList<BlockPos>();
                    ArrayDeque<BlockPos> coordsToCheck = new ArrayDeque<BlockPos>();
                    HashSet<BlockPos> checkedCoords = new HashSet<BlockPos>();
                    coordsToCheck.add(hitPos);
                    checkedCoords.add(hitPos);
                    while (!coordsToCheck.isEmpty() && coordsToPaint.size() < 1000) {
                        BlockPos coords = (BlockPos)coordsToCheck.remove();
                        coordsToPaint.add(coords);
                        for (Direction dir : Direction.values()) {
                            BlockPos candidatePos = coords.relative(dir);
                            if (!checkedCoords.add(candidatePos) || !entity.level().getBlockState(candidatePos).is(hitBlock)) continue;
                            coordsToCheck.add(candidatePos);
                        }
                    }
                    for (BlockPos coords : coordsToPaint) {
                        DyeColor placeColor = DyeColor.byId((int)(storedColor == 16 ? entity.level().random.nextInt(16) : storedColor));
                        BlockState stateThere = entity.level().getBlockState(coords);
                        Function<DyeColor, Block> f = BotaniaAPI.instance().getPaintableBlocks().get(blockId);
                        Block newBlock = f.apply(placeColor);
                        if (newBlock == stateThere.getBlock()) continue;
                        entity.level().setBlockAndUpdate(coords, newBlock.withPropertiesOf(stateThere));
                        XplatAbstractions.INSTANCE.sendToNear(entity.level(), coords, new BotaniaEffectPacket(EffectType.PAINT_LENS, coords.getX(), coords.getY(), coords.getZ(), placeColor.getId()));
                    }
                }
            }
        }
        return shouldKill;
    }
}

