/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

public abstract class FluidGeneratorBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    public static final int DECAY_TIME = 72000;
    protected int burnTime;
    protected int cooldown;
    private final TagKey<Fluid> consumedFluid;
    private final int startBurnTime;
    private final int manaPerTick;

    protected FluidGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, TagKey<Fluid> consumedFluid, int startBurnTime, int manaPerTick) {
        super(type, pos, state);
        this.consumedFluid = consumedFluid;
        this.startBurnTime = startBurnTime;
        this.manaPerTick = manaPerTick;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.1f, 0.1f, 0.1f, 1.0f);
                this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 30.0f, 0.0);
            }
        }
        if (!this.getLevel().isClientSide && this.burnTime > 0 && this.ticksExisted % this.getGenerationDelay() == 0) {
            this.addMana(this.manaPerTick);
            this.sync();
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana() && !this.getLevel().isClientSide) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    BlockPos pos = this.getEffectivePos().offset((Vec3i)offset);
                    BlockState bstate = this.getLevel().getBlockState(pos);
                    FluidState fstate = this.getLevel().getFluidState(pos);
                    if (!fstate.is(this.consumedFluid) || !fstate.isSource()) continue;
                    if (this.consumedFluid != FluidTags.WATER) {
                        this.getLevel().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    } else {
                        int waterAround = 0;
                        for (Direction dir : Direction.values()) {
                            if (!this.getLevel().getFluidState(pos.relative(dir)).is(this.consumedFluid)) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            Block block = bstate.getBlock();
                            if (block instanceof BucketPickup) {
                                BucketPickup bucketPickup = (BucketPickup)block;
                                bucketPickup.pickupBlock((LevelAccessor)this.getLevel(), pos, bstate);
                            } else {
                                this.getLevel().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                            }
                            this.getLevel().gameEvent(null, GameEvent.FLUID_PICKUP, pos);
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.startBurnTime;
                        this.getLevel().gameEvent(null, GameEvent.BLOCK_ACTIVATE, this.getBlockPos());
                    } else {
                        this.cooldown = this.getCooldownTime(false);
                    }
                    this.setChanged();
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.getLevel().random.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.getCooldownTime(true);
                this.getLevel().gameEvent(null, GameEvent.BLOCK_DEACTIVATE, this.getBlockPos());
                this.setChanged();
                this.sync();
            }
        }
    }

    public abstract int getCooldownTime(boolean var1);

    public int getGenerationDelay() {
        return 1;
    }

    public abstract void doBurnParticles();

    public abstract void playSound();

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.putInt(TAG_BURN_TIME, this.burnTime);
        cmp.putInt(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.getInt(TAG_BURN_TIME);
        this.cooldown = cmp.getInt(TAG_COOLDOWN);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }
}

