/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.FakeAirBlockEntity;

public class BubbellBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 12;
    private static final int RANGE_MINI = 6;
    private static final int COST_PER_TICK = 4;
    private static final String TAG_RANGE = "range";
    int range = 2;

    protected BubbellBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BubbellBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.BUBBELL, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.getMana() > 4) {
            this.addMana(-4);
            if (this.ticksExisted % 10 == 0 && this.range < this.getRange()) {
                ++this.range;
            }
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getEffectivePos().offset(-this.range, -this.range, -this.range), (BlockPos)this.getEffectivePos().offset(this.range, this.range, this.range))) {
                BlockState state;
                if (!(this.getEffectivePos().distSqr((Vec3i)pos) < (double)(this.range * this.range)) || !(state = this.getLevel().getBlockState(pos)).is(Blocks.WATER)) continue;
                this.getLevel().setBlock(pos, BotaniaBlocks.fakeAir.defaultBlockState(), 2);
                FakeAirBlockEntity air = (FakeAirBlockEntity)this.getLevel().getBlockEntity(pos);
                air.setFlower(this);
            }
        }
    }

    public static boolean isValidBubbell(Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof BubbellBlockEntity) {
            BubbellBlockEntity bubbell = (BubbellBlockEntity)tile;
            return bubbell.getMana() > 4;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.putInt(TAG_RANGE, this.range);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.range = cmp.getInt(TAG_RANGE);
    }

    @Override
    public int getMaxMana() {
        return 2000;
    }

    @Override
    public int getColor() {
        return 905097;
    }

    public int getRange() {
        return 12;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.range);
    }

    public static class Mini
    extends BubbellBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.BUBBELL_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 6;
        }
    }
}

