/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.corporea.CorporeaInterceptor;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;
import vazkii.botania.common.helper.FilterHelper;

public class CorporeaInterceptorBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaInterceptor {
    public CorporeaInterceptorBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_INTERCEPTOR, pos, state);
    }

    @Override
    public void interceptRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, CorporeaSpark source, List<ItemStack> stacks, Set<CorporeaNode> nodes, boolean doit) {
    }

    @Override
    public void interceptRequestLast(CorporeaRequestMatcher request, int count, CorporeaSpark spark, CorporeaSpark source, List<ItemStack> stacks, Set<CorporeaNode> nodes, boolean doit) {
        List<ItemStack> filter = this.getFilter();
        boolean filterMatch = false;
        for (ItemStack itemStack : filter) {
            if (!request.test(itemStack)) continue;
            filterMatch = true;
        }
        if (filterMatch || filter.isEmpty()) {
            int missing = count;
            for (ItemStack stack : stacks) {
                missing -= stack.getCount();
            }
            if (missing > 0 && !((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                BlockPos blockPos = source.getSparkNode().getPos();
                ArrayList<CorporeaRetainerBlockEntity> retainers = new ArrayList<CorporeaRetainerBlockEntity>();
                for (Direction dir : Direction.values()) {
                    BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(dir));
                    if (!(tile instanceof CorporeaRetainerBlockEntity)) continue;
                    CorporeaRetainerBlockEntity retainer = (CorporeaRetainerBlockEntity)tile;
                    retainers.add(retainer);
                    retainer.forget();
                }
                this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
                this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
                for (CorporeaRetainerBlockEntity retainer : retainers) {
                    retainer.remember(blockPos, request, count, missing);
                }
            }
        }
    }

    private List<ItemStack> getFilter() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        for (Direction dir : Direction.values()) {
            List frames = this.level.getEntitiesOfClass(ItemFrame.class, new AABB(this.worldPosition.relative(dir), this.worldPosition.relative(dir).offset(1, 1, 1)));
            for (ItemFrame frame : frames) {
                Direction orientation = frame.getDirection();
                if (orientation != dir) continue;
                filter.addAll(FilterHelper.getFilterItems(frame));
            }
        }
        return filter;
    }
}

