/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfheimPortalTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("open_elf_portal");
    public static final AlfheimPortalTrigger INSTANCE = new AlfheimPortalTrigger();

    private AlfheimPortalTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, ItemPredicate.fromJson((JsonElement)json.get("wand")), LocationPredicate.fromJson((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, ItemStack wand) {
        this.trigger(player, instance -> instance.test(world, pos, wand));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate wand;
        private final LocationPredicate pos;

        public Instance(ContextAwarePredicate playerPred, ItemPredicate predicate, LocationPredicate pos) {
            super(ID, playerPred);
            this.wand = predicate;
            this.pos = pos;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ServerLevel world, BlockPos pos, ItemStack wand) {
            return this.wand.matches(wand) && this.pos.matches(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.wand != ItemPredicate.ANY) {
                json.add("wand", this.wand.serializeToJson());
            }
            if (this.pos != LocationPredicate.ANY) {
                json.add("location", this.pos.serializeToJson());
            }
            return json;
        }

        public ItemPredicate getWand() {
            return this.wand;
        }

        public LocationPredicate getPos() {
            return this.pos;
        }
    }
}

