/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.block_entity.IncensePlateBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class IncensePlateBlockEntityRenderer
implements BlockEntityRenderer<IncensePlateBlockEntity> {
    public IncensePlateBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull IncensePlateBlockEntity plate, float ticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ItemStack stack = plate.getItemHandler().getItem(0);
        if (stack.isEmpty()) {
            return;
        }
        Direction facing = (Direction)plate.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ms.pushPose();
        ms.translate(0.5f, 1.5f, 0.5f);
        int degrees = switch (facing) {
            default -> 0;
            case Direction.WEST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.EAST -> 270;
        };
        ms.mulPose(VecHelper.rotateY(degrees));
        float s = 0.6f;
        ms.translate(-0.11f, -1.35f, 0.0f);
        ms.scale(s, s, s);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffers, plate.getLevel(), 0);
        ms.popPose();
    }
}

