/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.ears;

import com.unascribed.ears.api.EarsFeatureType;
import com.unascribed.ears.api.OverrideResult;
import com.unascribed.ears.api.registry.EarsInhibitorRegistry;
import com.unascribed.ears.api.registry.EarsStateOverriderRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;

public class EarsIntegration {
    public static void register() {
        EarsStateOverriderRegistry.register((String)"botania", (state, peer) -> {
            if (!(peer instanceof Player)) {
                return OverrideResult.DEFAULT;
            }
            Player player = (Player)peer;
            EquipmentSlot slot = null;
            switch (state) {
                case WEARING_HELMET: {
                    slot = EquipmentSlot.HEAD;
                    break;
                }
                case WEARING_CHESTPLATE: {
                    slot = EquipmentSlot.CHEST;
                    break;
                }
                case WEARING_LEGGINGS: {
                    slot = EquipmentSlot.LEGS;
                    break;
                }
                case WEARING_BOOTS: {
                    slot = EquipmentSlot.FEET;
                }
            }
            if (slot == null) {
                return OverrideResult.DEFAULT;
            }
            ItemStack stack = player.getItemBySlot(slot);
            Item patt1306$temp = stack.getItem();
            if (!(patt1306$temp instanceof PhantomInkable)) {
                return OverrideResult.DEFAULT;
            }
            PhantomInkable item = (PhantomInkable)patt1306$temp;
            if (!item.hasPhantomInk(stack)) {
                return OverrideResult.DEFAULT;
            }
            return OverrideResult.FALSE;
        });
        EarsInhibitorRegistry.register((String)"botania", (type, peer) -> {
            if (type != EarsFeatureType.WINGS) {
                return false;
            }
            if (!(peer instanceof Player)) {
                return false;
            }
            Player player = (Player)peer;
            Container equipment = EquipmentHandler.getAllWorn((LivingEntity)player);
            for (int slot = 0; slot < equipment.getContainerSize(); ++slot) {
                FlugelTiaraItem tiara;
                ItemStack item = equipment.getItem(slot);
                Item patt1899$temp = item.getItem();
                if (!(patt1899$temp instanceof FlugelTiaraItem) || !(tiara = (FlugelTiaraItem)patt1899$temp).hasRender(item, (LivingEntity)player) || FlugelTiaraItem.getVariant(item) <= 0) continue;
                return true;
            }
            return false;
        });
    }
}

