/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.function.Predicate;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;

public class LivingwoodSlingshotItem
extends Item {
    private static final Predicate<ItemStack> AMMO_FUNC = s -> s != null && s.is(BotaniaItems.vineBall);

    public LivingwoodSlingshotItem(Item.Properties builder) {
        super(builder);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity living, int duration) {
        block6: {
            int j;
            block7: {
                j = this.getUseDuration(stack) - duration;
                if (world.isClientSide) break block6;
                if (!(living instanceof Player)) break block7;
                Player player = (Player)living;
                if (!player.getAbilities().instabuild && !PlayerHelper.hasAmmo(player, AMMO_FUNC)) break block6;
            }
            float f = (float)j / 20.0f;
            if ((f = (f * f + f * 2.0f) / 3.0f) < 1.0f) {
                return;
            }
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.getAbilities().instabuild) {
                    PlayerHelper.consumeAmmo(player, AMMO_FUNC);
                }
            }
            VineBallEntity ball = new VineBallEntity(living, false);
            ball.shootFromRotation((Entity)living, living.getXRot(), living.getYRot(), 0.0f, 1.5f, 1.0f);
            ball.setDeltaMovement(ball.getDeltaMovement().scale(1.6));
            world.addFreshEntity((Entity)ball);
            world.playSound(null, living.getX(), living.getY(), living.getZ(), BotaniaSounds.vineBallThrow, SoundSource.NEUTRAL, 1.0f, 0.4f / (living.getRandom().nextFloat() * 0.4f + 0.8f));
        }
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getAbilities().instabuild || PlayerHelper.hasAmmo(player, AMMO_FUNC)) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

