/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class EthicalTntHelper {
    private static final ThreadLocal<EthicalTntHelper> tracker = ThreadLocal.withInitial(EthicalTntHelper::new);
    private final AtomicInteger trackTntEntities = new AtomicInteger();
    private final WeakHashMap<Level, IntOpenHashSet> trackedTntEntities = new WeakHashMap();

    public static void startTrackingTntEntities() {
        tracker.get().startTracking();
    }

    public static void addTrackedTntEntity(PrimedTnt entity) {
        tracker.get().addTrackedEntity(entity);
    }

    public static void endTrackingTntEntitiesAndCheck() {
        tracker.get().endTracking();
    }

    private void startTracking() {
        this.trackTntEntities.incrementAndGet();
    }

    private void addTrackedEntity(PrimedTnt entity) {
        if (this.trackTntEntities.get() > 0) {
            this.trackedTntEntities.computeIfAbsent(entity.level(), lvl -> new IntOpenHashSet()).add(entity.getId());
        }
    }

    private void endTracking() {
        if (this.trackTntEntities.decrementAndGet() == 0) {
            for (Map.Entry<Level, IntOpenHashSet> entry : this.trackedTntEntities.entrySet()) {
                Level level = entry.getKey();
                IntOpenHashSet trackedEntities = entry.getValue();
                if (trackedEntities == null) continue;
                for (Integer tntId : trackedEntities) {
                    Entity entity = level.getEntity(tntId.intValue());
                    if (!(entity instanceof PrimedTnt)) continue;
                    PrimedTnt tnt = (PrimedTnt)entity;
                    EthicalTntHelper.checkUnethical(tnt);
                }
                trackedEntities.clear();
            }
        }
    }

    private static void checkUnethical(PrimedTnt entity) {
        BlockPos center = entity.blockPosition();
        if (!entity.level().isLoaded(center)) {
            return;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            PistonMovingBlockEntity movingBlockEntity;
            BlockEntity blockEntity;
            BlockState blockState;
            blockPos.setWithOffset((Vec3i)center, dir);
            if (!entity.level().isLoaded((BlockPos)blockPos) || !(blockState = entity.level().getBlockState((BlockPos)blockPos)).is(Blocks.MOVING_PISTON) || !((blockEntity = entity.level().getBlockEntity((BlockPos)blockPos)) instanceof PistonMovingBlockEntity) || (movingBlockEntity = (PistonMovingBlockEntity)blockEntity).getMovementDirection() != dir || !(movingBlockEntity.getMovedState().getBlock() instanceof TntBlock) && !movingBlockEntity.getMovedState().is(BotaniaTags.Blocks.UNETHICAL_TNT_CHECK)) continue;
            XplatAbstractions.INSTANCE.ethicalComponent(entity).markUnethical();
            break;
        }
    }
}

