/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.WorldshaperssSextantItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.item.equipment.bauble.RingOfDexterousMotionItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.ClientXplatAbstractions;
import vazkii.botania.xplat.XplatAbstractions;

public final class HUDHandler {
    public static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/mana_hud.png");
    private static boolean didOptifineDetection = false;

    private HUDHandler() {
    }

    public static void tryOptifineWarning() {
        if (!didOptifineDetection) {
            try {
                Class.forName("optifine.Installer");
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"botaniamisc.optifine_warning"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            didOptifineDetection = true;
        }
    }

    public static void onDrawScreenPost(GuiGraphics gui, float partialTicks) {
        EntityHitResult result;
        WandHUD hud;
        HitResult pos;
        PoseStack ms = gui.pose();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        ProfilerFiller profiler = mc.getProfiler();
        ItemStack main = mc.player.getMainHandItem();
        ItemStack offhand = mc.player.getOffhandItem();
        profiler.push("botania-hud");
        if (Minecraft.getInstance().gameMode.canHurtPlayer()) {
            ItemStack dodgeRing;
            ItemStack tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (LivingEntity)mc.player);
            if (!tiara.isEmpty()) {
                profiler.push("flugelTiara");
                FlugelTiaraItem.ClientLogic.renderHUD(gui, (Player)mc.player, tiara);
                profiler.pop();
            }
            if (!(dodgeRing = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)mc.player)).isEmpty()) {
                profiler.push("dodgeRing");
                RingOfDexterousMotionItem.ClientLogic.renderHUD(gui, (Player)mc.player, dodgeRing, partialTicks);
                profiler.pop();
            }
        }
        if ((pos = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult result2 = (BlockHitResult)pos;
            BlockPos bpos = result2.getBlockPos();
            BlockState state = mc.level.getBlockState(bpos);
            BlockEntity tile = mc.level.getBlockEntity(bpos);
            if (PlayerHelper.hasAnyHeldItem((Player)mc.player)) {
                boolean alternateRecipeHudPosition = false;
                if (PlayerHelper.hasHeldItemClass((Player)mc.player, WandOfTheForestItem.class)) {
                    HUDHandler.tryOptifineWarning();
                    WandHUD hud2 = ClientXplatAbstractions.INSTANCE.findWandHud((Level)mc.level, bpos, state, tile);
                    if (hud2 != null) {
                        alternateRecipeHudPosition = true;
                        profiler.push("wandItem");
                        hud2.renderHUD(gui, mc);
                        profiler.pop();
                    }
                }
                if (tile instanceof ManaPoolBlockEntity) {
                    ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
                    if (!mc.player.getMainHandItem().isEmpty()) {
                        HUDHandler.renderPoolRecipeHUD(gui, pool, mc.player.getMainHandItem(), alternateRecipeHudPosition);
                    }
                }
            }
            if (!PlayerHelper.hasHeldItem((Player)mc.player, BotaniaItems.lexicon)) {
                if (tile instanceof PetalApothecaryBlockEntity) {
                    PetalApothecaryBlockEntity altar = (PetalApothecaryBlockEntity)tile;
                    PetalApothecaryBlockEntity.Hud.render(altar, gui, mc);
                } else if (tile instanceof RunicAltarBlockEntity) {
                    RunicAltarBlockEntity runeAltar = (RunicAltarBlockEntity)tile;
                    RunicAltarBlockEntity.Hud.render(runeAltar, gui, mc);
                } else if (tile instanceof CorporeaCrystalCubeBlockEntity) {
                    CorporeaCrystalCubeBlockEntity cube = (CorporeaCrystalCubeBlockEntity)tile;
                    CorporeaCrystalCubeBlockEntity.Hud.render(gui, cube);
                }
            }
        } else if (pos instanceof EntityHitResult && (hud = ClientXplatAbstractions.INSTANCE.findWandHud((result = (EntityHitResult)pos).getEntity())) != null && PlayerHelper.hasHeldItemClass((Player)mc.player, WandOfTheForestItem.class)) {
            profiler.push("wandItemEntityHud");
            hud.renderHUD(gui, mc);
            profiler.pop();
        }
        if (!CorporeaIndexBlockEntity.getNearbyValidIndexes((Player)mc.player).isEmpty() && mc.screen instanceof ChatScreen) {
            profiler.push("nearIndex");
            HUDHandler.renderNearIndexDisplay(gui);
            profiler.pop();
        }
        if (!main.isEmpty() && main.getItem() instanceof AssemblyHaloItem) {
            profiler.push("craftingHalo_main");
            AssemblyHaloItem.Rendering.renderHUD(gui, (Player)mc.player, main);
            profiler.pop();
        } else if (!offhand.isEmpty() && offhand.getItem() instanceof AssemblyHaloItem) {
            profiler.push("craftingHalo_off");
            AssemblyHaloItem.Rendering.renderHUD(gui, (Player)mc.player, offhand);
            profiler.pop();
        }
        if (!main.isEmpty() && main.getItem() instanceof WorldshaperssSextantItem) {
            profiler.push("sextant");
            WorldshaperssSextantItem.Hud.render(gui, (Player)mc.player, main);
            profiler.pop();
        }
        if (ManaseerMonocleItem.hasMonocle((LivingEntity)mc.player)) {
            profiler.push("monocle");
            ManaseerMonocleItem.Hud.render(gui, (Player)mc.player);
            profiler.pop();
        }
        profiler.push("manaBar");
        LocalPlayer player = mc.player;
        if (!player.isSpectator()) {
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            Inventory mainInv = player.getInventory();
            Container accInv = BotaniaAPI.instance().getAccessoriesInventory((Player)player);
            int invSize = mainInv.getContainerSize();
            int size = invSize + accInv.getContainerSize();
            for (int i = 0; i < size; ++i) {
                boolean useAccessories = i >= invSize;
                Object inv = useAccessories ? accInv : mainInv;
                ItemStack stack = inv.getItem(i - (useAccessories ? invSize : 0));
                if (stack.isEmpty()) continue;
                anyRequest = anyRequest || stack.is(BotaniaTags.Items.MANA_USING_ITEMS);
            }
            List<ItemStack> items = ManaItemHandler.instance().getManaItems((Player)player);
            List<ItemStack> acc = ManaItemHandler.instance().getManaAccesories((Player)player);
            for (ItemStack stack : Iterables.concat(items, acc)) {
                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                if (manaItem.isNoExport()) continue;
                totalMana += manaItem.getMana();
                totalMaxMana += manaItem.getMaxMana();
            }
            if (anyRequest) {
                HUDHandler.renderManaInvBar(gui, totalMana, totalMaxMana);
            }
        }
        profiler.popPush("itemsRemaining");
        ItemsRemainingRenderHandler.render(gui, partialTicks);
        profiler.pop();
        profiler.pop();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderManaInvBar(GuiGraphics gui, int totalMana, int totalMaxMana) {
        Minecraft mc = Minecraft.getInstance();
        int width = 182;
        int x = mc.getWindow().getGuiScaledWidth() / 2 - width / 2;
        int y = mc.getWindow().getGuiScaledHeight() - BotaniaConfig.client().manaBarHeight();
        width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = Mth.hsvToRgb((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)Util.getMillis() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 251, width, 5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(GuiGraphics gui, ManaPoolBlockEntity tile, ItemStack stack, boolean alternateRecipeHudPosition) {
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = mc.getProfiler();
        profiler.push("poolRecipe");
        ManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.getLevel().getBlockState(tile.getBlockPos().below()));
        if (recipe != null) {
            int x = mc.getWindow().getGuiScaledWidth() / 2 - 11;
            int y = mc.getWindow().getGuiScaledHeight() / 2 + (alternateRecipeHudPosition ? -25 : 10);
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.player.getName().getString().equals("haighyorkie") && mc.player.isShiftKeyDown() ? 23 : 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, u, v, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.renderItem(stack, x - 20, y);
            ItemStack result = recipe.getResultItem(mc.level.registryAccess());
            gui.renderItem(result, x + 26, y);
            gui.renderItemDecorations(mc.font, result, x + 26, y);
            RenderSystem.disableBlend();
        }
        profiler.pop();
    }

    private static void renderNearIndexDisplay(GuiGraphics gui) {
        Minecraft mc = Minecraft.getInstance();
        String txt0 = I18n.get((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = ChatFormatting.GRAY + I18n.get((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = ChatFormatting.GRAY + I18n.get((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.font.width(txt0), Math.max(mc.font.width(txt1), mc.font.width(txt2))) + 20;
        int x = mc.getWindow().getGuiScaledWidth() - l - 20;
        int y = mc.getWindow().getGuiScaledHeight() - 60;
        RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + l + 4, y + 35);
        gui.renderItem(new ItemStack((ItemLike)BotaniaBlocks.corporeaIndex), x, y + 10);
        gui.drawString(mc.font, txt0, x + 20, y, 0xFFFFFF);
        gui.drawString(mc.font, txt1, x + 20, y + 14, 0xFFFFFF);
        gui.drawString(mc.font, txt2, x + 20, y + 24, 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(GuiGraphics gui, int color, int mana, int maxMana, String name) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.getInstance();
        int x = mc.getWindow().getGuiScaledWidth() / 2 - mc.font.width(name) / 2;
        int y = mc.getWindow().getGuiScaledHeight() / 2 + 10;
        gui.drawString(mc.font, name, x, y, color);
        x = mc.getWindow().getGuiScaledWidth() / 2 - 51;
        HUDHandler.renderManaBar(gui, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.disableBlend();
    }

    public static void drawComplexManaHUD(int color, GuiGraphics gui, int mana, int maxMana, String name, ItemStack bindDisplay, boolean properlyBound) {
        PoseStack ms = gui.pose();
        HUDHandler.drawSimpleManaHUD(gui, color, mana, maxMana, name);
        Minecraft mc = Minecraft.getInstance();
        int x = mc.getWindow().getGuiScaledWidth() / 2 + Math.max(51, mc.font.width(name) / 2) + 4;
        int y = mc.getWindow().getGuiScaledHeight() / 2 + 12;
        gui.renderItem(bindDisplay, x, y);
        RenderSystem.disableDepthTest();
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 200.0f);
        if (properlyBound) {
            gui.drawString(mc.font, "\u2714", x + 10, y + 9, 19456);
            gui.drawString(mc.font, "\u2714", x + 10, y + 8, 774669);
        } else {
            gui.drawString(mc.font, "\u2718", x + 10, y + 9, 0x4C0000);
            gui.drawString(mc.font, "\u2718", x + 10, y + 8, 13764621);
        }
        ms.popPose();
        RenderSystem.enableDepthTest();
    }

    public static void renderManaBar(GuiGraphics gui, int x, int y, int color, float alpha, int mana, int maxMana) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(gui, manaBar, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

