/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.block.flower.functional.LooniumBlockEntity;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.item.EquestrianVirusItem;
import vazkii.botania.common.item.equipment.bauble.CrimsonPendantItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    abstract EntityType<?> getType();

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void checkInvulnerabilities(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity) {
            LivingEntity self = (LivingEntity)entityMixin;
            if (EquestrianVirusItem.onLivingHurt(self, source)) {
                cir.setReturnValue((Object)true);
            } else if (CrimsonPendantItem.onDamage(self, source)) {
                cir.setReturnValue((Object)true);
            }
        }
        if (source.is(BotaniaDamageTypes.KEY_EXPLOSION) && this.getType().is(BotaniaTags.Entities.KEY_IMMUNE)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getTeam"}, cancellable=true)
    private void getLooniumTeam(CallbackInfoReturnable<Team> cir) {
        Mob self;
        LooniumComponent looniumComponent;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Mob && (looniumComponent = XplatAbstractions.INSTANCE.looniumComponent((LivingEntity)(self = (Mob)entityMixin))) != null && looniumComponent.isSlowDespawn() && !looniumComponent.getDrop().isEmpty()) {
            cir.setReturnValue((Object)LooniumBlockEntity.LOONIUM_TEAM);
        }
    }
}

