/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockLootProvider
implements DataProvider {
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().hasEnchantment(new EnchantmentPredicate(Enchantments.SILK_TOUCH, MinMaxBounds.Ints.atLeast((int)1))));
    private static final Function<Block, LootTable.Builder> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final PackOutput.PathProvider pathProvider;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(PackOutput packOutput) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables/blocks");
        for (Block b2 : BuiltInRegistries.BLOCK) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b2);
            if (!"botania".equals(id.getNamespace())) continue;
            if (b2 instanceof SlabBlock) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (b2 instanceof BotaniaDoubleFlowerBlock) {
                this.functionTable.put(b2, BlockLootProvider::genDoubleFlower);
                continue;
            }
            if (b2 instanceof BotaniaGrassBlock) {
                this.functionTable.put(b2, BlockLootProvider::genAltGrass);
                continue;
            }
            if (b2 instanceof FlowerPotBlock) {
                FlowerPotBlock flowerPot = (FlowerPotBlock)b2;
                this.functionTable.put(b2, block -> BlockLootProvider.createPotAndPlantItemTable((ItemLike)flowerPot.getContent()));
                continue;
            }
            if (!id.getPath().matches("metamorphic_\\w+_stone")) continue;
            this.functionTable.put(b2, BlockLootProvider::genMetamorphicStone);
        }
        this.functionTable.put(BotaniaBlocks.bifrost, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cocoon, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.fakeAir, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.manaFlame, BlockLootProvider::empty);
        this.functionTable.put(BotaniaBlocks.cacophonium, b -> BlockLootProvider.genRegular(Blocks.NOTE_BLOCK));
        this.functionTable.put(BotaniaBlocks.enchantedSoil, b -> BlockLootProvider.genRegular(Blocks.DIRT));
        this.functionTable.put(BotaniaBlocks.enchanter, b -> BlockLootProvider.genRegular(Blocks.LAPIS_BLOCK));
        this.functionTable.put(BotaniaBlocks.cellBlock, BlockLootProvider::genCellBlock);
        this.functionTable.put(BotaniaBlocks.root, BlockLootProvider::genRoot);
        this.functionTable.put(BotaniaBlocks.solidVines, BlockLootProvider::genSolidVine);
        this.functionTable.put(BotaniaBlocks.tinyPotato, BlockLootProvider::genTinyPotato);
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllis, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.gourmaryllisFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeas, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.hydroangeasFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdew, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.munchdewFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsia, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.rafflowsiaFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolus, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.spectrolusFloating, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(BotaniaFlowerBlocks.thermalilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block b : BuiltInRegistries.BLOCK) {
            Function<Block, LootTable.Builder> func;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b);
            if (!"botania".equals(id.getNamespace()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.json((ResourceLocation)e.getKey());
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)Deserializers.createLootTableSerializer().create().toJsonTree((Object)((LootTable.Builder)e.getValue()).setParamSet(LootContextParamSets.BLOCK).build()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected static LootTable.Builder empty(Block b) {
        return LootTable.lootTable();
    }

    @Nullable
    protected static LootTable.Builder skip(Block b) {
        return null;
    }

    protected static LootTable.Builder genCopyNbt(Block b, String ... tags) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)b);
        CopyNbtFunction.Builder func = CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY);
        for (String tag : tags) {
            func = func.copy(tag, "BlockEntityTag." + tag);
        }
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry).when(ExplosionCondition.survivesExplosion()).apply((LootItemFunction.Builder)func);
        return LootTable.lootTable().withPool(pool);
    }

    protected static LootTable.Builder genCellBlock(Block b) {
        ItemPredicate.Builder silkPred = ItemPredicate.Builder.item().hasEnchantment(new EnchantmentPredicate(Enchantments.SILK_TOUCH, MinMaxBounds.Ints.atLeast((int)1)));
        LootPoolEntryContainer.Builder silk = LootItem.lootTableItem((ItemLike)b).when(MatchTool.toolMatches((ItemPredicate.Builder)silkPred));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(silk));
    }

    protected static LootTable.Builder genTinyPotato(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)b).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry).when(ExplosionCondition.survivesExplosion());
        return LootTable.lootTable().withPool(pool);
    }

    protected static LootTable.Builder genMetamorphicStone(Block b) {
        String cobbleName = BuiltInRegistries.BLOCK.getKey((Object)b).getPath().replaceAll("_stone", "_cobblestone");
        Block cobble = (Block)BuiltInRegistries.BLOCK.getOptional(ResourceLocationHelper.prefix(cobbleName)).get();
        return BlockLootProvider.genSilkDrop((ItemLike)b, (ItemLike)cobble);
    }

    protected static LootTable.Builder genSilkDrop(ItemLike silkDrop, ItemLike normalDrop) {
        LootPoolEntryContainer.Builder cobbleDrop = LootItem.lootTableItem((ItemLike)normalDrop).when(ExplosionCondition.survivesExplosion());
        LootPoolEntryContainer.Builder stoneDrop = LootItem.lootTableItem((ItemLike)silkDrop).when(SILK_TOUCH);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)stoneDrop.otherwise(cobbleDrop)));
    }

    protected static LootTable.Builder genSolidVine(Block b) {
        LootPoolSingletonContainer.Builder entry = LootTableReference.lootTableReference((ResourceLocation)new ResourceLocation("blocks/vine"));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genRoot(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)BotaniaItems.livingroot).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genSlab(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)b).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genDoubleFlower(Block b) {
        LootPoolSingletonContainer.Builder entry = (LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)b).when(ExplosionCondition.survivesExplosion())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TallFlowerBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder genAltGrass(Block b) {
        LootPoolEntryContainer.Builder silk = LootItem.lootTableItem((ItemLike)b).when(SILK_TOUCH);
        LootPoolEntryContainer.Builder dirt = LootItem.lootTableItem((ItemLike)Blocks.DIRT).when(ExplosionCondition.survivesExplosion());
        AlternativesEntry.Builder entry = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{silk, dirt});
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry);
        return LootTable.lootTable().withPool(pool);
    }

    protected static LootTable.Builder genRegular(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)b);
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entry).when(ExplosionCondition.survivesExplosion());
        return LootTable.lootTable().withPool(pool);
    }

    protected static LootTable.Builder createPotAndPlantItemTable(ItemLike plant) {
        LootPool.Builder potPool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.FLOWER_POT)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(ExplosionCondition.survivesExplosion());
        LootPool.Builder plantPool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)plant)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(ExplosionCondition.survivesExplosion());
        return LootTable.lootTable().withPool(potPool).withPool(plantPool);
    }

    @NotNull
    public String getName() {
        return "Botania block loot tables";
    }
}

