/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.mixin.AbstractCauldronBlockAccessor;

public class ExtrapolatedBucketItem
extends Item {
    public ExtrapolatedBucketItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = ExtrapolatedBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos2, direction, itemStack)) {
            BlockState blockState = level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                itemStack2 = bucketPickup.pickupBlock((LevelAccessor)level, blockPos, blockState);
                if (!itemStack2.isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    bucketPickup.getPickupSound().ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
                    ExtrapolatedBucketItem.spawnParticles(level, blockPos);
                    level.gameEvent((Entity)player, GameEvent.FLUID_PICKUP, blockPos);
                    ItemStack itemStack3 = itemStack;
                    if (!level.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, (ItemStack)itemStack2);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)itemStack3, (boolean)level.isClientSide());
                }
            } else {
                AbstractCauldronBlock cauldronBlock;
                CauldronInteraction interaction;
                itemStack2 = blockState.getBlock();
                if (itemStack2 instanceof AbstractCauldronBlock && (interaction = ((AbstractCauldronBlockAccessor)(cauldronBlock = (AbstractCauldronBlock)itemStack2)).botania_getInteractions().get(Items.BUCKET)) != null) {
                    BlockState fullState = blockState.hasProperty((Property)LayeredCauldronBlock.LEVEL) ? (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)) : blockState;
                    InteractionResult result = interaction.interact(fullState, level, blockPos, player, interactionHand, itemStack.copy());
                    if (result.consumesAction()) {
                        ExtrapolatedBucketItem.spawnParticles(level, blockPos);
                    }
                    if (!ItemStack.matches((ItemStack)player.getItemInHand(interactionHand), (ItemStack)itemStack)) {
                        player.setItemInHand(interactionHand, itemStack);
                    }
                    return new InteractionResultHolder(result, (Object)itemStack);
                }
            }
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    private static void spawnParticles(Level level, BlockPos blockPos) {
        for (int x = 0; x < 5; ++x) {
            level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)blockPos.getX() + Math.random(), (double)blockPos.getY() + Math.random(), (double)blockPos.getZ() + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

